/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security;

import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.PersistedRole;
import org.apache.activemq.artemis.core.persistence.config.PersistedUser;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.User;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager5;
import org.apache.activemq.artemis.spi.core.security.UserManagement;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.SecurityManagerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQBasicSecurityManager
implements ActiveMQSecurityManager5,
UserManagement {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String BOOTSTRAP_USER = "bootstrapUser";
    public static final String BOOTSTRAP_PASSWORD = "bootstrapPassword";
    public static final String BOOTSTRAP_ROLE = "bootstrapRole";
    public static final String BOOTSTRAP_USER_FILE = "bootstrapUserFile";
    public static final String BOOTSTRAP_ROLE_FILE = "bootstrapRoleFile";
    private Map<String, String> properties;
    private StorageManager storageManager;

    @Override
    public ActiveMQBasicSecurityManager init(Map<String, String> properties) {
        if (!(properties.containsKey(BOOTSTRAP_USER) && properties.containsKey(BOOTSTRAP_PASSWORD) && properties.containsKey(BOOTSTRAP_ROLE) || properties.containsKey(BOOTSTRAP_USER_FILE) && properties.containsKey(BOOTSTRAP_ROLE_FILE))) {
            ActiveMQServerLogger.LOGGER.noBootstrapCredentialsFound();
        } else {
            this.properties = properties;
        }
        return this;
    }

    @Override
    public boolean validateUser(String user, String password) {
        throw new UnsupportedOperationException("Invoke authenticate(String, String, RemotingConnection, String) instead");
    }

    @Override
    public Subject authenticate(String userToAuthenticate, String passwordToAuthenticate, RemotingConnection remotingConnection, String securityDomain) {
        try {
            User user;
            PersistedUser persistedUser;
            if (this.storageManager.isStarted() && this.storageManager.getPersistedUsers() != null && (persistedUser = this.storageManager.getPersistedUsers().get(userToAuthenticate)) != null && (user = new User(persistedUser.getUsername(), persistedUser.getPassword())).isValid(userToAuthenticate, passwordToAuthenticate)) {
                Subject subject = new Subject();
                subject.getPrincipals().add(new UserPrincipal(userToAuthenticate));
                for (String role : this.getRole(userToAuthenticate).getRoles()) {
                    subject.getPrincipals().add((Principal)SecurityManagerUtil.createGroupPrincipal(role, RolePrincipal.class));
                }
                return subject;
            }
        }
        catch (Exception e) {
            logger.debug("Couldn't validate user", (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
        throw new UnsupportedOperationException("Invoke authorize(Subject, Set<Role>, CheckType, String) instead");
    }

    @Override
    public boolean authorize(Subject subject, Set<Role> roles, CheckType checkType, String address) {
        boolean authorized = SecurityManagerUtil.authorize(subject, roles, checkType, RolePrincipal.class);
        if (authorized) {
            logger.trace("user is authorized");
        } else {
            logger.trace("user is NOT authorized");
        }
        return authorized;
    }

    @Override
    public synchronized void addNewUser(String user, String password, String ... roles) throws Exception {
        if (user == null) {
            throw ActiveMQMessageBundle.BUNDLE.nullUser();
        }
        if (password == null) {
            throw ActiveMQMessageBundle.BUNDLE.nullPassword();
        }
        if (this.userExists(user)) {
            throw ActiveMQMessageBundle.BUNDLE.userAlreadyExists(user);
        }
        this.storageManager.storeUser(new PersistedUser(user, password));
        this.storageManager.storeRole(new PersistedRole(user, Arrays.asList(roles)));
    }

    @Override
    public synchronized void removeUser(String user) throws Exception {
        if (!this.userExists(user)) {
            throw ActiveMQMessageBundle.BUNDLE.userDoesNotExist(user);
        }
        this.storageManager.deleteUser(user);
        this.storageManager.deleteRole(user);
    }

    @Override
    public synchronized Map<String, Set<String>> listUser(String user) {
        if (user != null && !user.isEmpty() && !this.userExists(user)) {
            throw ActiveMQMessageBundle.BUNDLE.userDoesNotExist(user);
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (user != null && !user.isEmpty()) {
            result.put(user, new HashSet<String>(this.getRole(user).getRoles()));
        } else {
            for (String thisUser : this.storageManager.getPersistedUsers().keySet()) {
                result.put(thisUser, new HashSet<String>(this.getRole(thisUser).getRoles()));
            }
        }
        return result;
    }

    @Override
    public synchronized void updateUser(String user, String password, String ... roles) throws Exception {
        if (!this.userExists(user)) {
            throw ActiveMQMessageBundle.BUNDLE.userDoesNotExist(user);
        }
        if (password != null) {
            this.storageManager.deleteUser(user);
            this.storageManager.storeUser(new PersistedUser(user, password));
        }
        if (roles != null && roles.length > 0) {
            this.storageManager.deleteRole(user);
            this.storageManager.storeRole(new PersistedRole(user, Arrays.asList(roles)));
        }
    }

    public void completeInit(StorageManager storageManager) {
        this.storageManager = storageManager;
        if (this.properties != null && this.properties.containsKey(BOOTSTRAP_USER_FILE) && this.properties.containsKey(BOOTSTRAP_ROLE_FILE)) {
            Properties users = ClassloadingUtil.loadProperties((String)this.properties.get(BOOTSTRAP_USER_FILE));
            Map<String, Set<String>> rolesByUser = this.invertProperties(ClassloadingUtil.loadProperties((String)this.properties.get(BOOTSTRAP_ROLE_FILE)));
            for (String user : users.stringPropertyNames()) {
                this.addOrUpdateUser(user, users.getProperty(user), rolesByUser.get(user).toArray(new String[0]));
            }
        } else if (this.properties != null && this.properties.containsKey(BOOTSTRAP_USER) && this.properties.containsKey(BOOTSTRAP_PASSWORD) && this.properties.containsKey(BOOTSTRAP_ROLE)) {
            this.addOrUpdateUser(this.properties.get(BOOTSTRAP_USER), this.properties.get(BOOTSTRAP_PASSWORD), this.properties.get(BOOTSTRAP_ROLE));
        }
    }

    private void addOrUpdateUser(String user, String password, String ... roles) {
        try {
            if (this.userExists(user)) {
                this.updateUser(user, password, roles);
            } else {
                this.addNewUser(user, password, roles);
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToCreateBootstrapCredentials(user, e);
        }
    }

    private Map<String, Set<String>> invertProperties(Properties props) {
        HashMap<String, Set<String>> invertedProps = new HashMap<String, Set<String>>();
        for (Map.Entry<Object, Object> val : props.entrySet()) {
            for (String user : ((String)val.getValue()).split(",")) {
                HashSet<String> tempRoles = (HashSet<String>)invertedProps.get(user);
                if (tempRoles == null) {
                    tempRoles = new HashSet<String>();
                    invertedProps.put(user, tempRoles);
                }
                tempRoles.add((String)val.getKey());
            }
        }
        return invertedProps;
    }

    private boolean userExists(String user) {
        return user != null && this.storageManager.getPersistedUsers() != null && this.storageManager.getPersistedUsers().containsKey(user);
    }

    private PersistedRole getRole(String user) {
        return this.storageManager.getPersistedRoles().get(user);
    }
}

