/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.activemq.artemis.utils;

public final class DataConstants {

   public static final int SIZE_INT = 4;

   public static final int SIZE_BOOLEAN = 1;

   public static final int SIZE_LONG = 8;

   public static final int SIZE_BYTE = 1;

   public static final int SIZE_SHORT = 2;

   public static final int SIZE_DOUBLE = 8;

   public static final int SIZE_FLOAT = 4;

   public static final int SIZE_CHAR = 2;

   public static final int SIZE_NULL = 1;

   public static final byte TRUE = 1;

   public static final byte FALSE = 0;

   public static final byte NULL = 0;

   public static final byte NOT_NULL = 1;

   public static final byte BOOLEAN = 2;

   public static final byte BYTE = 3;

   public static final byte BYTES = 4;

   public static final byte SHORT = 5;

   public static final byte INT = 6;

   public static final byte LONG = 7;

   public static final byte FLOAT = 8;

   public static final byte DOUBLE = 9;

   public static final byte STRING = 10;

   public static final byte CHAR = 11;
}
