/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.domestic.extractor;

import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.domestic.extractor.DocumentExtractor;
import net.openhft.chronicle.wire.domestic.extractor.ToLongDocumentExtractor;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ToDoubleDocumentExtractor {
    public double extractAsDouble(@NotNull Wire var1, @NonNegative long var2);

    default public ToDoubleDocumentExtractor map(@NotNull DoubleUnaryOperator mapper) {
        ObjectUtils.requireNonNull((Object)mapper);
        return (wire, index) -> {
            double value = this.extractAsDouble(wire, index);
            if (Double.isNaN(value)) {
                return Double.NaN;
            }
            return mapper.applyAsDouble(value);
        };
    }

    default public <T> DocumentExtractor<T> mapToObj(@NotNull DoubleFunction<? extends T> mapper) {
        ObjectUtils.requireNonNull(mapper);
        return (wire, index) -> {
            double value = this.extractAsDouble(wire, index);
            if (Double.isNaN(value)) {
                return null;
            }
            return mapper.apply(value);
        };
    }

    default public ToLongDocumentExtractor mapToLong(@NotNull DoubleToLongFunction mapper) {
        ObjectUtils.requireNonNull((Object)mapper);
        return (wire, index) -> {
            double value = this.extractAsDouble(wire, index);
            if (Double.isNaN(value)) {
                return Long.MIN_VALUE;
            }
            return mapper.applyAsLong(value);
        };
    }

    default public ToDoubleDocumentExtractor filter(@NotNull DoublePredicate predicate) {
        ObjectUtils.requireNonNull((Object)predicate);
        return (wire, index) -> {
            double value = this.extractAsDouble(wire, index);
            if (Double.isNaN(value)) {
                return Double.NaN;
            }
            return predicate.test(value) ? value : Double.NaN;
        };
    }
}

