/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.dbsync;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.access.dbsync.BaseSchemaUpdateStrategy;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIfNoSchemaStrategy
extends BaseSchemaUpdateStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateIfNoSchemaStrategy.class);

    @Override
    protected void processSchemaUpdate(DataNode dataNode) throws SQLException {
        Map<String, Boolean> nameTables = this.getNameTablesInDB(dataNode);
        Collection<DbEntity> entities = dataNode.getEntityResolver().getDbEntities();
        boolean generate = true;
        Iterator<DbEntity> it = entities.iterator();
        while (it.hasNext()) {
            if (nameTables.get(it.next().getName()) == null) continue;
            generate = false;
            break;
        }
        if (generate) {
            LOGGER.info("No schema detected, will create mapped tables");
            this.generate(dataNode);
        } else {
            LOGGER.info("Full or partial schema detected, skipping tables creation");
        }
    }

    private void generate(DataNode dataNode) {
        Collection<DataMap> map = dataNode.getDataMaps();
        Iterator<DataMap> iterator = map.iterator();
        while (iterator.hasNext()) {
            DbGenerator gen = new DbGenerator(dataNode.getAdapter(), iterator.next(), dataNode.getJdbcEventLogger());
            gen.setShouldCreateTables(true);
            gen.setShouldDropTables(false);
            gen.setShouldCreateFKConstraints(true);
            gen.setShouldCreatePKSupport(true);
            gen.setShouldDropPKSupport(false);
            try {
                gen.runGenerator(dataNode.getDataSource());
            }
            catch (Exception e) {
                throw new CayenneRuntimeException(e);
            }
        }
    }

    protected Map<String, Boolean> getNameTablesInDB(DataNode dataNode) throws SQLException {
        String tableLabel = dataNode.getAdapter().tableTypeForTable();
        HashMap<String, Boolean> nameTables = new HashMap<String, Boolean>();
        try (Connection con = dataNode.getDataSource().getConnection();
             ResultSet rs = con.getMetaData().getTables(null, null, "%", new String[]{tableLabel});){
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                nameTables.put(name, false);
            }
        }
        return nameTables;
    }
}

