/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.protocol.PbTransportableError;
import org.apache.celeborn.common.util.ExceptionUtils;

public class TransportableError
extends RequestMessage {
    private long streamId;
    private byte[] errorMessage;

    public TransportableError(long streamId, Throwable throwable) {
        this.streamId = streamId;
        this.errorMessage = ExceptionUtils.stringifyException(throwable).getBytes(StandardCharsets.UTF_8);
    }

    public TransportableError(long streamId, byte[] errorMessage) {
        this.streamId = streamId;
        this.errorMessage = errorMessage;
    }

    @Override
    public int encodedLength() {
        return 12 + this.errorMessage.length;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.streamId);
        buf.writeInt(this.errorMessage.length);
        buf.writeBytes(this.errorMessage);
    }

    @Override
    public Message.Type type() {
        return Message.Type.TRANSPORTABLE_ERROR;
    }

    public static TransportableError decode(ByteBuf buf) {
        long streamId = buf.readLong();
        int msgLen = buf.readInt();
        byte[] errorMsg = new byte[msgLen];
        buf.readBytes(errorMsg);
        return new TransportableError(streamId, errorMsg);
    }

    public long getStreamId() {
        return this.streamId;
    }

    public String getErrorMessage() {
        return new String(this.errorMessage, StandardCharsets.UTF_8);
    }

    public static TransportableError fromProto(PbTransportableError pb) {
        return new TransportableError(pb.getStreamId(), pb.getMessage().getBytes(StandardCharsets.UTF_8));
    }
}

