/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.retry;

import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;

public class ClientRetryEvent
implements RetryPolicy.Event {
    private final int attemptCount;
    private final int causeCount;
    private final RaftClientRequest request;
    private final Throwable cause;
    private final Timestamp pendingRequestCreationTime;

    public ClientRetryEvent(int attemptCount, RaftClientRequest request, int causeCount, Throwable cause, Timestamp pendingRequestCreationTime) {
        this.attemptCount = attemptCount;
        this.causeCount = causeCount;
        this.request = request;
        this.cause = cause;
        this.pendingRequestCreationTime = pendingRequestCreationTime;
    }

    public int getAttemptCount() {
        return this.attemptCount;
    }

    public int getCauseCount() {
        return this.causeCount;
    }

    public RaftClientRequest getRequest() {
        return this.request;
    }

    public Throwable getCause() {
        return this.cause;
    }

    boolean isRequestTimeout(TimeDuration timeout) {
        return timeout != null && this.pendingRequestCreationTime.elapsedTime().compareTo(timeout) >= 0;
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ":attempt=" + this.attemptCount + ",request=" + this.request + ",cause=" + this.cause + ",causeCount=" + this.causeCount;
    }
}

