/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.common.CelebornConf;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.shuffle.celeborn.ShuffleFallbackPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkersAvailableFallbackPolicy
implements ShuffleFallbackPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(WorkersAvailableFallbackPolicy.class);
    public static final WorkersAvailableFallbackPolicy INSTANCE = new WorkersAvailableFallbackPolicy();

    @Override
    public boolean needFallback(ShuffleDependency<?, ?, ?> shuffleDependency, CelebornConf celebornConf, LifecycleManager lifecycleManager) {
        boolean needFallback;
        if (!celebornConf.checkWorkerEnabled()) {
            return false;
        }
        boolean bl = needFallback = !lifecycleManager.checkWorkersAvailable().getAvailable();
        if (needFallback) {
            LOG.warn("No celeborn workers available for current user {}.", (Object)lifecycleManager.getUserIdentifier());
        }
        return needFallback;
    }
}

