/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.http.api.v1;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.celeborn.rest.v1.model.HandleResponse;
import org.apache.celeborn.rest.v1.model.LoggerInfo;
import org.apache.celeborn.rest.v1.model.LoggerInfos;
import org.apache.celeborn.server.common.HttpService;
import org.apache.celeborn.server.common.http.api.ApiRequestContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@Tag(name="Logger")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001\u0002\u0003\u0006\u0001YAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005\u0002\u0019Bq!a\n\u0001\t\u0003\tIC\u0001\bM_\u001e<WM\u001d*fg>,(oY3\u000b\u0005\u00199\u0011A\u0001<2\u0015\tA\u0011\"A\u0002ba&T!AC\u0006\u0002\t!$H\u000f\u001d\u0006\u0003\u00195\taaY8n[>t'B\u0001\b\u0010\u0003\u0019\u0019XM\u001d<fe*\u0011\u0001#E\u0001\tG\u0016dWMY8s]*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u00192\u0001A\f\u001e!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fMB\u0011adH\u0007\u0002\u000f%\u0011\u0001e\u0002\u0002\u0012\u0003BL'+Z9vKN$8i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0001$!\t!\u0003!D\u0001\u0006\u000399W\r\u001e'pO\u001e,'\u000fT3wK2$2a\n\u0019K!\tAc&D\u0001*\u0015\tQ3&A\u0003n_\u0012,GN\u0003\u0002\u0007Y)\u0011QfD\u0001\u0005e\u0016\u001cH/\u0003\u00020S\tYAj\\4hKJLeNZ8t\u0011\u0015\t$\u00011\u00013\u0003\u0011q\u0017-\\3\u0011\u0005MRdB\u0001\u001b9!\t)\u0014$D\u00017\u0015\t9T#\u0001\u0004=e>|GOP\u0005\u0003se\ta\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\u0019\u0019FO]5oO*\u0011\u0011(\u0007\u0015\u0005ayB\u0015\n\u0005\u0002@\r6\t\u0001I\u0003\u0002B\u0005\u0006\u0011!o\u001d\u0006\u0003\u0007\u0012\u000b!a^:\u000b\u0003\u0015\u000bQA[1wCbL!a\u0012!\u0003\u0015E+XM]=QCJ\fW.A\u0003wC2,X-I\u00012\u0011\u0015Y%\u00011\u0001M\u0003\r\tG\u000e\u001c\t\u000315K!AT\r\u0003\u000f\t{w\u000e\\3b]\"\"!\n\u00150`!\t\tF,D\u0001S\u0015\t\u0019F+A\u0006b]:|G/\u0019;j_:\u001c(BA+W\u0003\ry\u0017m\u001d\u0006\u0003/b\u000b!A^\u001a\u000b\u0005eS\u0016aB:xC\u001e<WM\u001d\u0006\u00027\u0006\u0011\u0011n\\\u0005\u0003;J\u0013\u0011\u0002U1sC6,G/\u001a:\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0002A\u0006i%+\u001a;ve:\u0004\u0013\r\u001c7!Y><w-\u001a:!S:\u001cH/\u00198dKN\u0004\u0013N\u001a\u0011ueV,G\u0006I8uQ\u0016\u0014x/[:fAI,G/\u001e:oA\u0005dG\u000eI2p]\u001aLw-\u001e:fI\u0002bwnZ4feNt\u0003\u0006\u0002&c\u0011\u0016\u0004\"aP2\n\u0005\u0011\u0004%\u0001\u0004#fM\u0006,H\u000e\u001e,bYV,\u0017%\u00014\u0002\u000b\u0019\fGn]3)\t)s\u0004\n[\u0011\u0002\u0017\"\u0012!A\u001b\t\u0003\u007f-L!\u0001\u001c!\u0003\u0007\u001d+E\u000b\u000b\u0004\u0003]R,x\u000f\u001f\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cJ\u000b\u0011B]3ta>t7/Z:\n\u0005M\u0004(aC!qSJ+7\u000f]8og\u0016\fAB]3ta>t7/Z\"pI\u0016\f\u0013A^\u0001\u0004eA\u0002\u0014aB2p]R,g\u000e\u001e\u0017\u0002s.J!0!\u0001\u0002\u0004\u0005\u001d\u0011\u0011\u0002\t\u0003wzl\u0011\u0001 \u0006\u0003{J\u000bQ!\\3eS\u0006L!a ?\u0003\u000f\r{g\u000e^3oi\u0006IQ.\u001a3jCRK\b/Z\u0011\u0003\u0003\u000b\t\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8\u0002\rM\u001c\u0007.Z7bW\u0019\tY!!\u0005\u0002\u0014A\u001910!\u0004\n\u0007\u0005=AP\u0001\u0004TG\",W.Y\u0001\u000fS6\u0004H.Z7f]R\fG/[8oG\t\t)\u0002E\u0002)\u0003/I1!!\u0007*\u0005)aunZ4fe&sgm\u001c\u0015\u0007\u0005\u0005ua,a\t\u0011\u0007E\u000by\"C\u0002\u0002\"I\u0013\u0011b\u00149fe\u0006$\u0018n\u001c8\"\u0005\u0005\u0015\u0012AP$fi\u0002\"\b.\u001a\u0011m_\u001e<WM\u001d\u0011mKZ,G\u000e\f\u0011sKR,(O\u001c\u0011bY2\u0004Cn\\4hKJ\u001c\b%\u001b4!]>\u0004c.Y7fAM\u0004XmY5gS\u0016$g&\u0001\btKRdunZ4fe2+g/\u001a7\u0015\t\u0005-\u0012\u0011\u0007\t\u0004Q\u00055\u0012bAA\u0018S\tq\u0001*\u00198eY\u0016\u0014Vm\u001d9p]N,\u0007bBA\u001a\u0007\u0001\u0007\u0011QC\u0001\be\u0016\fX/Z:uQ\r\u0019\u0011q\u0007\t\u0004\u007f\u0005e\u0012bAA\u001e\u0001\n!\u0001kT*UQ\u001d\u0019a\u000e^;x\u0003\u007fa#!!\u0011,\u0013i\f\t!a\u0001\u0002\b\u0005\r3FBA\u0006\u0003#\t)e\t\u0002\u0002,!21!!\b_\u0003\u0013\n#!a\u0013\u0002+M+G\u000f\t;iK\u0002bwnZ4fe\u0002bWM^3m]!2\u0001!a\u0014I\u0003+\u00022aPA)\u0013\r\t\u0019\u0006\u0011\u0002\t\u0007>t7/^7fg2\u0012\u00111\u0001\u0015\u0007\u0001\u0005e\u0003*a\u0018\u0011\u0007}\nY&C\u0002\u0002^\u0001\u0013\u0001\u0002\u0015:pIV\u001cWm\u001d\u0017\u0003\u0003\u0007Ac\u0001AA2c\u0005=\u0004\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%$+\u0001\u0003uC\u001e\u001c\u0018\u0002BA7\u0003O\u00121\u0001V1hC\t\t\t(\u0001\u0004M_\u001e<WM\u001d")
public class LoggerResource
implements ApiRequestContext {
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public final HttpService httpService() {
        return ApiRequestContext.httpService$(this);
    }

    @Override
    public String normalizeParam(String param) {
        return ApiRequestContext.normalizeParam$(this, param);
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @Operation(description="Get the logger level, return all loggers if no name specified.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=LoggerInfo.class))})
    @GET
    public LoggerInfos getLoggerLevel(@QueryParam(value="name") String name, @QueryParam(value="all") @DefaultValue(value="false") @Parameter(description="Return all logger instances if true, otherwise return all configured loggers.") boolean all) {
        if (name != null) {
            return new LoggerInfos().addLoggersItem(new LoggerInfo().name(name).level(LogManager.getLogger((String)name).getLevel().toString()));
        }
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Seq loggers = all ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(loggerContext.getLoggers()).asScala()).map((Function1 & Serializable & scala.Serializable)logger -> new LoggerInfo().name(logger.getName()).level(logger.getLevel().toString()), Iterable$.MODULE$.canBuildFrom())).toSeq() : ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(loggerContext.getConfiguration().getLoggers().values()).asScala()).map((Function1 & Serializable & scala.Serializable)loggerConfig -> new LoggerInfo().name(loggerConfig.getName()).level(loggerConfig.getLevel().toString()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        return new LoggerInfos().loggers((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)loggers.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), (Ordering)Ordering.String$.MODULE$)).asJava());
    }

    @Operation(description="Set the logger level.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    public HandleResponse setLoggerLevel(LoggerInfo request) {
        String loggerName = request.getName();
        Logger logger = LogManager.getLogger((String)loggerName);
        Level originalLevel = logger.getLevel();
        Level newLevel = Level.toLevel((String)request.getLevel());
        Configurator.setLevel((String)loggerName, (Level)newLevel);
        return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(new StringBuilder(35).append("Set logger `").append(loggerName).append("` level from `").append(originalLevel).append("` to `").append(newLevel).append("`.`").toString());
    }

    public LoggerResource() {
        ApiRequestContext.$init$(this);
    }
}

