/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.commons.statistics.descriptive.IntMath;
import org.apache.commons.statistics.descriptive.UInt128;

final class UInt192 {
    private static final long MASK32 = 0xFFFFFFFFL;
    private int f;
    private int e;
    private int d;
    private int c;
    private long ab;

    private UInt192() {
    }

    UInt192(long hi, long mid, long lo) {
        this.f = (int)lo;
        this.e = (int)(lo >>> 32);
        this.d = (int)mid;
        this.c = (int)(mid >>> 32);
        this.ab = hi;
    }

    private UInt192(long ab, int c, int d, int e, int f) {
        this.ab = ab;
        this.c = c;
        this.d = d;
        this.e = e;
        this.f = f;
    }

    static UInt192 create() {
        return new UInt192();
    }

    void addSquare(long x) {
        long lo = x * x;
        long hi = IntMath.squareHigh(x);
        long s = (lo & 0xFFFFFFFFL) + ((long)this.f & 0xFFFFFFFFL);
        this.f = (int)s;
        s = (s >>> 32) + (lo >>> 32) + ((long)this.e & 0xFFFFFFFFL);
        this.e = (int)s;
        s = (s >>> 32) + (hi & 0xFFFFFFFFL) + ((long)this.d & 0xFFFFFFFFL);
        this.d = (int)s;
        s = (s >>> 32) + (hi >>> 32) + ((long)this.c & 0xFFFFFFFFL);
        this.c = (int)s;
        this.ab += s >>> 32;
    }

    void add(UInt192 x) {
        int ff = x.f;
        int ee = x.e;
        int dd = x.d;
        int cc = x.c;
        long aabb = x.ab;
        long s = ((long)ff & 0xFFFFFFFFL) + ((long)this.f & 0xFFFFFFFFL);
        this.f = (int)s;
        s = (s >>> 32) + ((long)ee & 0xFFFFFFFFL) + ((long)this.e & 0xFFFFFFFFL);
        this.e = (int)s;
        s = (s >>> 32) + ((long)dd & 0xFFFFFFFFL) + ((long)this.d & 0xFFFFFFFFL);
        this.d = (int)s;
        s = (s >>> 32) + ((long)cc & 0xFFFFFFFFL) + ((long)this.c & 0xFFFFFFFFL);
        this.c = (int)s;
        this.ab += (s >>> 32) + aabb;
    }

    UInt192 unsignedMultiply(int x) {
        long xx = (long)x & 0xFFFFFFFFL;
        long product = xx * ((long)this.f & 0xFFFFFFFFL);
        int ff = (int)product;
        product = (product >>> 32) + xx * ((long)this.e & 0xFFFFFFFFL);
        int ee = (int)product;
        product = (product >>> 32) + xx * ((long)this.d & 0xFFFFFFFFL);
        int dd = (int)product;
        product = (product >>> 32) + xx * ((long)this.c & 0xFFFFFFFFL);
        int cc = (int)product;
        long aabb = (product >>> 32) + xx * this.ab;
        return new UInt192(aabb, cc, dd, ee, ff);
    }

    UInt192 subtract(UInt128 x) {
        long diff = ((long)this.f & 0xFFFFFFFFL) - ((long)x.lo32() & 0xFFFFFFFFL);
        int ff = (int)diff;
        diff = (diff >> 32) + ((long)this.e & 0xFFFFFFFFL) - ((long)x.mid32() & 0xFFFFFFFFL);
        int ee = (int)diff;
        diff = (diff >> 32) + ((long)this.d & 0xFFFFFFFFL) - (x.hi64() & 0xFFFFFFFFL);
        int dd = (int)diff;
        diff = (diff >> 32) + ((long)this.c & 0xFFFFFFFFL) - (x.hi64() >>> 32);
        int cc = (int)diff;
        long aabb = (diff >> 32) + this.ab;
        return new UInt192(aabb, cc, dd, ee, ff);
    }

    BigInteger toBigInteger() {
        ByteBuffer bb = ByteBuffer.allocate(24).putLong(this.ab).putInt(this.c).putInt(this.d).putInt(this.e).putInt(this.f);
        return new BigInteger(1, bb.array());
    }

    double toDouble() {
        long h = this.hi64();
        long m = this.mid64();
        long l = this.lo64();
        if (h == 0L) {
            return IntMath.uint128ToDouble(m, l);
        }
        return IntMath.uint128ToDouble(h, m | (long)(l == 0L ? 0 : 1)) * 1.8446744073709552E19;
    }

    int toIntExact() {
        return Math.toIntExact(this.toLongExact());
    }

    long toLongExact() {
        if ((this.ab | (long)this.c | (long)this.d) != 0L || this.e < 0) {
            throw new ArithmeticException("long integer overflow");
        }
        return this.lo64();
    }

    long lo64() {
        return (long)this.f & 0xFFFFFFFFL | ((long)this.e & 0xFFFFFFFFL) << 32;
    }

    long mid64() {
        return (long)this.d & 0xFFFFFFFFL | ((long)this.c & 0xFFFFFFFFL) << 32;
    }

    long hi64() {
        return this.ab;
    }
}

