/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.sse;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.sse.InboundSseEvent;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.microprofile.client.sse.SsePublisher;
import org.apache.cxf.microprofile.client.sse.SseSubscription;
import org.apache.cxf.microprofile.client.sse.SseTypeSafeSubscription;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SseTypeSafeProcessor<T>
implements Processor<InboundSseEvent, T> {
    private static final Logger LOG = LogUtils.getL7dLogger(SseTypeSafeProcessor.class);
    private SseSubscription incomingSubscription;
    private final SsePublisher ssePublisher;
    private final List<Subscriber<? super T>> subscribers = new LinkedList<Subscriber<? super T>>();
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final GenericType<?> type;
    private final AtomicBoolean isSubscribed = new AtomicBoolean();

    SseTypeSafeProcessor(GenericType<T> type, SsePublisher ssePublisher) {
        this.type = type;
        this.ssePublisher = ssePublisher;
    }

    public void onSubscribe(Subscription s) {
        this.incomingSubscription = (SseSubscription)s;
        LOG.finest("onSubscribe " + s);
    }

    public void onNext(InboundSseEvent t) {
        LOG.entering(SseTypeSafeProcessor.class.getName(), "onNext", t);
        if (this.incomingSubscription == null) {
            throw new IllegalStateException("not subscribed");
        }
        if (!this.isClosed.get()) {
            Object data = t.readData(this.type);
            for (Subscriber<? super T> subscriber : this.subscribers) {
                subscriber.onNext(data);
            }
        }
        LOG.exiting(SseTypeSafeProcessor.class.getName(), "onNext");
    }

    public void onError(Throwable t) {
        if (this.isClosed.compareAndSet(false, true)) {
            for (Subscriber<? super T> subscriber : this.subscribers) {
                subscriber.onError(t);
            }
        }
    }

    public void onComplete() {
        if (this.isClosed.compareAndSet(false, true)) {
            for (Subscriber<? super T> subscriber : this.subscribers) {
                subscriber.onComplete();
            }
        }
    }

    public void subscribe(Subscriber<? super T> s) {
        LOG.finest("subscribe " + s);
        this.subscribers.add(s);
        if (this.isSubscribed.compareAndSet(false, true)) {
            this.ssePublisher.subscribe((Subscriber<? super InboundSseEvent>)this);
        }
        if (this.incomingSubscription == null) {
            throw new IllegalStateException();
        }
        s.onSubscribe((Subscription)new SseTypeSafeSubscription(this.incomingSubscription));
    }
}

