/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import org.apache.daffodil.api.DataLocation;
import org.apache.daffodil.io.BacktrackingException;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.SchemaFileLocation;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.runtime1.processors.DataProcessor;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.ParseError;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface Parser
extends Processor {
    public static void $init$(Parser $this) {
    }

    public static boolean isEmpty$(Parser $this) {
        return $this.isEmpty();
    }

    @Override
    default public boolean isEmpty() {
        return false;
    }

    public static String parserName$(Parser $this) {
        return $this.parserName();
    }

    default public String parserName() {
        return Misc$.MODULE$.getNameFromClass(this);
    }

    public static void PE$(Parser $this, PState pstate, String s, Seq args) {
        $this.PE(pstate, s, (Seq<Object>)args);
    }

    default public void PE(PState pstate, String s, Seq<Object> args) {
        pstate.setFailed(new ParseError(Maybe$One$.MODULE$.apply(this.context().schemaFileLocation()), Maybe$One$.MODULE$.apply(pstate.currentLocation()), s, args));
    }

    public static void PE$(Parser $this, PState pstate, SchemaFileLocation sfl, DataLocation dataLoc, String s, Seq args) {
        $this.PE(pstate, sfl, dataLoc, s, (Seq<Object>)args);
    }

    default public void PE(PState pstate, SchemaFileLocation sfl, DataLocation dataLoc, String s, Seq<Object> args) {
        pstate.setFailed(new ParseError(Maybe$One$.MODULE$.apply(sfl), Maybe$One$.MODULE$.apply(dataLoc), s, args));
    }

    public static void PENotEnoughBits$(Parser $this, PState pstate, SchemaFileLocation sfl, DataLocation dataLoc, long neededBits, InputSourceDataInputStream source) {
        $this.PENotEnoughBits(pstate, sfl, dataLoc, neededBits, source);
    }

    default public void PENotEnoughBits(PState pstate, SchemaFileLocation sfl, DataLocation dataLoc, long neededBits, InputSourceDataInputStream source) {
        long l;
        long remainingLimitedBits;
        long startPos = dataLoc.bitPos1b() - 1L;
        if (MaybeULong$.MODULE$.isEmpty$extension(source.bitLimit0b())) {
            v0 = MaybeULong$.MODULE$.Nope();
        } else {
            long lim = MaybeULong$.MODULE$.get$extension(source.bitLimit0b());
            if (lim < 0L) {
                throw Assert$.MODULE$.abort("Invariant broken: lim.>=(0)");
            }
            long nBits = lim - startPos;
            v0 = remainingLimitedBits = MaybeULong$.MODULE$.apply(nBits);
        }
        if (source.hasReachedEndOfData()) {
            long bitsAvailableFromStartPos;
            long fragmentBitsReadFromSourcePos = source.bitPos0b() % 8L;
            long bitsAvailableFromSourcePos = source.knownBytesAvailable() * 8L - fragmentBitsReadFromSourcePos;
            long bitsBetweenStartPosAndSourcePos = source.bitPos0b() - startPos;
            long bitsAvailable = bitsAvailableFromStartPos = bitsAvailableFromSourcePos + bitsBetweenStartPosAndSourcePos;
            l = MaybeULong$.MODULE$.isEmpty$extension(remainingLimitedBits) || bitsAvailable < MaybeULong$.MODULE$.get$extension(remainingLimitedBits) ? bitsAvailable : MaybeULong$.MODULE$.get$extension(remainingLimitedBits);
        } else {
            l = MaybeULong$.MODULE$.get$extension(remainingLimitedBits);
        }
        long remainingBits = l;
        this.PE(pstate, sfl, dataLoc, "Insufficient bits in data. Needed %d bit(s) but found only %d available", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)neededBits), BoxesRunTime.boxToLong((long)remainingBits)}));
    }

    public static void PENotEnoughBits$(Parser $this, PState pstate, SchemaFileLocation sfl, DataLocation dataLoc, long neededBits) {
        $this.PENotEnoughBits(pstate, sfl, dataLoc, neededBits);
    }

    default public void PENotEnoughBits(PState pstate, SchemaFileLocation sfl, DataLocation dataLoc, long neededBits) {
        this.PE(pstate, sfl, dataLoc, "Insufficient bits in data. Needed %d bit(s)", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)neededBits)}));
    }

    public static void PENotEnoughBits$(Parser $this, PState pstate, long neededBits, InputSourceDataInputStream source) {
        $this.PENotEnoughBits(pstate, neededBits, source);
    }

    default public void PENotEnoughBits(PState pstate, long neededBits, InputSourceDataInputStream source) {
        this.PENotEnoughBits(pstate, pstate.schemaFileLocation(), pstate.currentLocation(), neededBits, source);
    }

    public static void processingError$(Parser $this, PState state, String str, Seq args) {
        $this.processingError(state, str, (Seq<Object>)args);
    }

    default public void processingError(PState state, String str, Seq<Object> args) {
        this.PE(state, str, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{args}));
    }

    public void parse(PState var1);

    public static void parse1$(Parser $this, PState pstate) {
        $this.parse1(pstate);
    }

    default public void parse1(PState pstate) {
        if (!this.isInitialized()) {
            throw Assert$.MODULE$.abort("Invariant broken: Parser.this.isInitialized");
        }
        Object savedParser = pstate.maybeProcessor();
        pstate.setProcessor(this);
        Object object = pstate.dataProc();
        if (Maybe$.MODULE$.isDefined$extension(object)) {
            Object object2 = pstate.dataProc();
            ((DataProcessor)Maybe$.MODULE$.get$extension(object2)).before(pstate, this);
        }
        try {
            try {
                this.parse(pstate);
            }
            catch (ParseError pe) {
                pstate.setFailed(pe);
            }
            catch (BacktrackingException be) {
                throw pstate.SDE("Attempted to backtrack too far: " + be.getMessage(), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
        }
        finally {
            pstate.resetFormatInfoCaches();
            Object object3 = pstate.dataProc();
            if (Maybe$.MODULE$.isDefined$extension(object3)) {
                Object object4 = pstate.dataProc();
                ((DataProcessor)Maybe$.MODULE$.get$extension(object4)).after(pstate, this);
            }
            pstate.setMaybeProcessor(savedParser);
        }
    }
}

