/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class XHTMLPrefixRemover
extends ProxyReceiver {
    public XHTMLPrefixRemover(Receiver next) {
        super(next);
    }

    private boolean isSpecial(NamespaceUri uri) {
        return uri.equals(NamespaceUri.XHTML) || uri.equals(NamespaceUri.SVG) || uri.equals(NamespaceUri.MATHML);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        for (NamespaceBinding ns : namespaces) {
            if (!this.isSpecial(ns.getNamespaceUri())) continue;
            namespaces = namespaces.remove(ns.getPrefix());
        }
        if (this.isSpecial(elemName.getNamespaceUri())) {
            NamespaceUri uri = elemName.getNamespaceUri();
            if (!elemName.getPrefix().isEmpty()) {
                elemName = new FingerprintedQName("", uri, elemName.getLocalPart());
            }
            namespaces = namespaces.put("", uri);
        }
        for (AttributeInfo att : attributes) {
            if (!this.isSpecial(att.getNodeName().getNamespaceUri())) continue;
            namespaces = namespaces.put(att.getNodeName().getPrefix(), att.getNodeName().getNamespaceUri());
        }
        this.nextReceiver.startElement(elemName, type, attributes, namespaces, location, properties);
    }
}

