/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.api.sax;

import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.FidelityOptions;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.util.xml.QNameUtilities;
import com.siemens.ct.exi.main.api.sax.SAXEncoder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXEncoderExtendedHandler
extends SAXEncoder {
    protected final boolean preserveDTD;
    protected final boolean preserveComment;
    protected final boolean preservePrefix;
    protected String docTypeName;
    protected String docTypePublicID;
    protected String docTypeSystemID;
    protected String docTypeText;
    protected boolean entityReferenceRange;
    protected boolean dtdRange;
    protected boolean retainEntityReference;

    public SAXEncoderExtendedHandler(EXIFactory factory) throws EXIException {
        super(factory);
        FidelityOptions fo = factory.getFidelityOptions();
        this.preserveDTD = fo.isFidelityEnabled("PRESERVE_DTDS");
        this.preserveComment = fo.isFidelityEnabled("PRESERVE_COMMENTS");
        this.preservePrefix = fo.isFidelityEnabled("PRESERVE_PREFIXES");
        this.retainEntityReference = factory.getEncodingOptions().isOptionEnabled("KEEP_ENTITY_REFERENCES_UNRESOLVED");
    }

    @Override
    public void startDocument() throws SAXException {
        this.entityReferenceRange = false;
        this.dtdRange = false;
        super.startDocument();
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes attributes) throws SAXException {
        try {
            String prefix = null;
            if (this.preservePrefix) {
                prefix = QNameUtilities.getPrefixPart((String)raw);
            }
            this.startElementPfx(uri, local, prefix, attributes);
        }
        catch (Exception e) {
            throw new SAXException("startElement: " + raw, e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.preserveDTD && this.entityReferenceRange) {
            if (!this.retainEntityReference) {
                super.characters(ch, start, length);
            }
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.dtdRange) {
            if (this.preserveDTD) {
                this.docTypeText = this.docTypeText + "<!--" + new String(ch, start, length) + "-->";
            }
        } else if (this.preserveComment) {
            try {
                this.encoder.encodeComment(ch, start, length);
            }
            catch (Exception e) {
                throw new SAXException("comment", e);
            }
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            if (this.dtdRange) {
                if (this.preserveDTD) {
                    this.docTypeText = this.docTypeText + "<?" + target + " " + data + "?>";
                }
            } else {
                this.encoder.encodeProcessingInstruction(target, data);
            }
        }
        catch (Exception e) {
            throw new SAXException("processingInstruction", e);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        try {
            if (this.preserveDTD) {
                this.docTypeName = name;
                this.docTypePublicID = publicId == null ? "" : publicId;
                this.docTypeSystemID = systemId == null ? "" : systemId;
                this.docTypeText = "";
            }
            this.dtdRange = true;
        }
        catch (Exception e) {
            throw new SAXException("startDTD", e);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        try {
            if (this.preserveDTD) {
                this.encoder.encodeDocType(this.docTypeName, this.docTypePublicID, this.docTypeSystemID, this.docTypeText);
            }
            this.dtdRange = false;
        }
        catch (Exception e) {
            throw new SAXException("endDTD", e);
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (!this.preserveDTD || this.retainEntityReference) {
            // empty if block
        }
        this.entityReferenceRange = true;
    }

    @Override
    public void endEntity(String name) throws SAXException {
        try {
            if (this.preserveDTD && this.entityReferenceRange && this.retainEntityReference && !name.startsWith("%") && !name.equals("[dtd]")) {
                this.encoder.encodeEntityReference(name);
            }
            this.entityReferenceRange = false;
        }
        catch (Exception e) {
            throw new SAXException("endEntity " + name, e);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        try {
            if (this.preserveDTD) {
                this.encoder.encodeEntityReference(name);
            }
        }
        catch (Exception e) {
            throw new SAXException("skippedEntity " + name, e);
        }
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    @Override
    public void elementDecl(String name, String model) throws SAXException {
        if (this.preserveDTD) {
            this.docTypeText = this.docTypeText + "<!ELEMENT " + name + " " + model + "> ";
        }
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        if (this.preserveDTD) {
            this.docTypeText = this.docTypeText + "<!ATTLIST " + eName + " " + aName + " " + type + " " + mode + "> ";
        }
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.preserveDTD) {
            this.docTypeText = this.docTypeText + "<!ENTITY " + name + " \"" + value + "\"> ";
        }
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }
}

