/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CoderResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.daffodil.io.Active$;
import org.apache.daffodil.io.DOSState;
import org.apache.daffodil.io.DataOutputStream;
import org.apache.daffodil.io.DataStreamCommonImplMixin;
import org.apache.daffodil.io.DataStreamCommonState;
import org.apache.daffodil.io.DirectOrBufferedDataOutputStream;
import org.apache.daffodil.io.FileIOException;
import org.apache.daffodil.io.Finished$;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.LocalBufferMixin;
import org.apache.daffodil.io.Uninitialized$;
import org.apache.daffodil.io.ZeroLengthStatus;
import org.apache.daffodil.io.ZeroLengthStatus$NonZero$;
import org.apache.daffodil.io.ZeroLengthStatus$Unknown$;
import org.apache.daffodil.io.ZeroLengthStatus$Zero$;
import org.apache.daffodil.io.processors.charset.BitsCharsetEncoder;
import org.apache.daffodil.io.processors.charset.BitsCharsetNonByteSizeEncoder;
import org.apache.daffodil.lib.equality.package$TypeEqual$;
import org.apache.daffodil.lib.equality.package$TypeEquality$;
import org.apache.daffodil.lib.equality.package$ViewEqual$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder$MostSignificantBitFirst$;
import org.apache.daffodil.lib.schema.annotation.props.gen.ByteOrder;
import org.apache.daffodil.lib.schema.annotation.props.gen.ByteOrder$BigEndian$;
import org.apache.daffodil.lib.schema.annotation.props.gen.ByteOrder$LittleEndian$;
import org.apache.daffodil.lib.util.Bits$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.MaybeULong$;
import passera.unsigned.ULong$;
import scala.Byte$;
import scala.DummyImplicit$;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface DataOutputStreamImplMixin
extends DataStreamCommonState,
DataOutputStream,
DataStreamCommonImplMixin,
LocalBufferMixin {
    public static void $init$(DataOutputStreamImplMixin $this) {
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$$relBitPos0b__$eq(ULong$.MODULE$.apply(0L));
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus__$eq(ZeroLengthStatus$Unknown$.MODULE$);
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeStartingRelBitPos0bAfterMerging__$eq(MaybeULong$.MODULE$.Nope());
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b__$eq(MaybeULong$.MODULE$.Nope());
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits__$eq(MaybeULong$.MODULE$.Nope());
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeLengthInBits__$eq(MaybeULong$.MODULE$.Nope());
        $this.maybeAbsBitLimit0b_$eq(MaybeULong$.MODULE$.Nope());
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b__$eq(MaybeULong$.MODULE$.Nope());
        $this.bitStartOffset0b_$eq(0);
        $this.debugOutputStream_$eq(Maybe$.MODULE$.Nope());
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByte__$eq(0);
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByteLimit__$eq(0);
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$$_dosState_$eq(Active$.MODULE$);
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$unionByteBuffer_$eq(ByteBuffer.allocate(8));
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$org$apache$daffodil$io$DataOutputStreamImplMixin$$unionDoubleBuffer_$eq($this.unionByteBuffer().asDoubleBuffer());
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$org$apache$daffodil$io$DataOutputStreamImplMixin$$unionFloatBuffer_$eq($this.unionByteBuffer().asFloatBuffer());
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$org$apache$daffodil$io$DataOutputStreamImplMixin$$unionIntBuffer_$eq($this.unionByteBuffer().asIntBuffer());
        $this.org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$unionLongBuffer_$eq($this.unionByteBuffer().asLongBuffer());
    }

    public /* synthetic */ void org$apache$daffodil$io$DataOutputStreamImplMixin$$super$assignFrom(DataStreamCommonState var1);

    public long org$apache$daffodil$io$DataOutputStreamImplMixin$$relBitPos0b_();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$relBitPos0b__$eq(long var1);

    public ZeroLengthStatus org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus_();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus__$eq(ZeroLengthStatus var1);

    public long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeStartingRelBitPos0bAfterMerging_();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeStartingRelBitPos0bAfterMerging__$eq(long var1);

    public static ZeroLengthStatus zeroLengthStatus$(DataOutputStreamImplMixin $this) {
        return $this.zeroLengthStatus();
    }

    @Override
    default public ZeroLengthStatus zeroLengthStatus() {
        ZeroLengthStatus zeroLengthStatus = this.org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus_();
        if (!ZeroLengthStatus$Zero$.MODULE$.equals(zeroLengthStatus) && !ZeroLengthStatus$NonZero$.MODULE$.equals(zeroLengthStatus)) {
            if (ZeroLengthStatus$Unknown$.MODULE$.equals(zeroLengthStatus)) {
                if (this.isFinished() || this.isDead()) {
                    this.org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus__$eq(ZeroLengthStatus$Zero$.MODULE$);
                }
            } else {
                throw new MatchError((Object)zeroLengthStatus);
            }
        }
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus_();
    }

    public static void setNonZeroLength$(DataOutputStreamImplMixin $this) {
        $this.setNonZeroLength();
    }

    default public void setNonZeroLength() {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus__$eq(ZeroLengthStatus$NonZero$.MODULE$);
    }

    public long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b_();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b__$eq(long var1);

    private void checkInvariants() {
    }

    public static long maybeAbsBitPos0b$(DataOutputStreamImplMixin $this) {
        return $this.maybeAbsBitPos0b();
    }

    @Override
    default public long maybeAbsBitPos0b() {
        long mas = this.maybeAbsStartingBitPos0b();
        if (MaybeULong$.MODULE$.isDefined$extension(mas)) {
            long st = MaybeULong$.MODULE$.get$extension(mas);
            long rel = this.relBitPos0b();
            long abs = st + rel;
            return MaybeULong$.MODULE$.apply(abs);
        }
        return MaybeULong$.MODULE$.Nope();
    }

    public static long maybeAbsStartingBitPos0b$(DataOutputStreamImplMixin $this) {
        return $this.maybeAbsStartingBitPos0b();
    }

    default public long maybeAbsStartingBitPos0b() {
        if (MaybeULong$.MODULE$.isDefined$extension(this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits_())) {
            return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits_();
        }
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b_();
    }

    public static long toAbsolute$(DataOutputStreamImplMixin $this, long relBitPos0b) {
        return $this.toAbsolute(relBitPos0b);
    }

    default public long toAbsolute(long relBitPos0b) {
        if (!MaybeULong$.MODULE$.isDefined$extension(this.maybeAbsStartingBitPos0b())) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.maybeAbsStartingBitPos0b.isDefined");
        }
        return ULong$.MODULE$.$plus$extension(MaybeULong$.MODULE$.getULong$extension(this.maybeAbsStartingBitPos0b()), relBitPos0b);
    }

    public static void resetAllBitPos$(DataOutputStreamImplMixin $this) {
        $this.resetAllBitPos();
    }

    default public void resetAllBitPos() {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits__$eq(MaybeULong$.MODULE$.Nope());
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b__$eq(MaybeULong$.MODULE$.Nope());
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$relBitPos0b__$eq(ULong$.MODULE$.apply(0L));
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus__$eq(ZeroLengthStatus$Unknown$.MODULE$);
    }

    public static void setAbsStartingBitPos0b$(DataOutputStreamImplMixin $this, long newStartingBitPos0b) {
        $this.setAbsStartingBitPos0b(newStartingBitPos0b);
    }

    default public void setAbsStartingBitPos0b(long newStartingBitPos0b) {
        Object object;
        this.checkInvariants();
        long mv = MaybeULong$.MODULE$.apply(newStartingBitPos0b);
        if (MaybeULong$.MODULE$.isEmpty$extension(this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b_()) && MaybeULong$.MODULE$.isEmpty$extension(this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits_())) {
            this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b__$eq(mv);
        } else if (MaybeULong$.MODULE$.isDefined$extension(this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b_())) {
            this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits__$eq(this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b_());
            this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b__$eq(mv);
        } else {
            throw Assert$.MODULE$.usageError("You cannot set the abs starting bit pos again.");
        }
        this.checkInvariants();
        if (MaybeULong$.MODULE$.isDefined$extension(this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeLengthInBits_()) && Maybe$.MODULE$.isDefined$extension(object = this.maybeNextInChain())) {
            Object object2 = this.maybeNextInChain();
            DirectOrBufferedDataOutputStream nic = (DirectOrBufferedDataOutputStream)((DataOutputStream)Maybe$.MODULE$.get$extension(object2));
            if (MaybeULong$.MODULE$.isEmpty$extension(nic.maybeAbsBitPos0b())) {
                long nextAbsPos = ULong$.MODULE$.$plus$extension(MaybeULong$.MODULE$.getULong$extension(this.maybeAbsStartingBitPos0b()), MaybeULong$.MODULE$.getULong$extension(this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeLengthInBits_()));
                nic.setAbsStartingBitPos0b(nextAbsPos);
                return;
            }
            return;
        }
    }

    public static void setRelBitPos0b$(DataOutputStreamImplMixin $this, long newRelBitPos0b) {
        $this.setRelBitPos0b(newRelBitPos0b);
    }

    @Override
    default public void setRelBitPos0b(long newRelBitPos0b) {
        if (!this.isWritable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isWritable");
        }
        this.checkInvariants();
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$relBitPos0b__$eq(newRelBitPos0b);
        this.checkInvariants();
    }

    public static void setLengthInBits$(DataOutputStreamImplMixin $this, long newLengthInBits) {
        $this.setLengthInBits(newLengthInBits);
    }

    default public void setLengthInBits(long newLengthInBits) {
        if (!MaybeULong$.MODULE$.isEmpty$extension(this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeLengthInBits_())) {
            throw Assert$.MODULE$.abort("Invariant broken: DataOutputStreamImplMixin.this.maybeLengthInBits_.isEmpty");
        }
        if (!this.isWritable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isWritable");
        }
        this.checkInvariants();
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeLengthInBits__$eq(MaybeULong$.MODULE$.apply(newLengthInBits));
        this.checkInvariants();
    }

    public static long relBitPos0b$(DataOutputStreamImplMixin $this) {
        return $this.relBitPos0b();
    }

    @Override
    default public long relBitPos0b() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$relBitPos0b_();
    }

    public long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits_();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits__$eq(long var1);

    public long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeLengthInBits_();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeLengthInBits__$eq(long var1);

    @Override
    public long maybeAbsBitLimit0b();

    public void maybeAbsBitLimit0b_$eq(long var1);

    public long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b_();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b__$eq(long var1);

    public static long maybeRelBitLimit0b$(DataOutputStreamImplMixin $this) {
        return $this.maybeRelBitLimit0b();
    }

    @Override
    default public long maybeRelBitLimit0b() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b_();
    }

    public static boolean setMaybeRelBitLimit0b$(DataOutputStreamImplMixin $this, long newMaybeRelBitLimit0b, boolean reset) {
        return $this.setMaybeRelBitLimit0b(newMaybeRelBitLimit0b, reset);
    }

    @Override
    default public boolean setMaybeRelBitLimit0b(long newMaybeRelBitLimit0b, boolean reset) {
        if (!(MaybeULong$.MODULE$.isDefined$extension(this.maybeAbsBitLimit0b()) && MaybeULong$.MODULE$.isDefined$extension(this.maybeRelBitLimit0b()) || MaybeULong$.MODULE$.isEmpty$extension(this.maybeAbsBitLimit0b()))) {
            throw Assert$.MODULE$.abort("Invariant broken: DataOutputStreamImplMixin.this.maybeAbsBitLimit0b.isDefined.&&(DataOutputStreamImplMixin.this.maybeRelBitLimit0b.isDefined).||(DataOutputStreamImplMixin.this.maybeAbsBitLimit0b.isEmpty)");
        }
        if (MaybeULong$.MODULE$.isEmpty$extension(newMaybeRelBitLimit0b)) {
            this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b__$eq(MaybeULong$.MODULE$.Nope());
            this.maybeAbsBitLimit0b_$eq(MaybeULong$.MODULE$.Nope());
        } else if (MaybeULong$.MODULE$.isEmpty$extension(this.maybeRelBitLimit0b())) {
            this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b__$eq(newMaybeRelBitLimit0b);
            if (!MaybeULong$.MODULE$.isEmpty$extension(this.maybeAbsBitLimit0b())) {
                throw Assert$.MODULE$.abort("Invariant broken: DataOutputStreamImplMixin.this.maybeAbsBitLimit0b.isEmpty");
            }
        } else {
            long delta = MaybeULong$.MODULE$.get$extension(this.maybeRelBitLimit0b()) - MaybeULong$.MODULE$.get$extension(newMaybeRelBitLimit0b);
            if (!reset && delta < 0L) {
                return false;
            }
            this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b__$eq(MaybeULong$.MODULE$.apply(MaybeULong$.MODULE$.get$extension(this.maybeRelBitLimit0b()) - delta));
            if (MaybeULong$.MODULE$.isDefined$extension(this.maybeAbsBitLimit0b())) {
                this.maybeAbsBitLimit0b_$eq(MaybeULong$.MODULE$.apply(MaybeULong$.MODULE$.get$extension(this.maybeAbsBitLimit0b()) - delta));
            }
        }
        return true;
    }

    public static boolean setMaybeRelBitLimit0b$default$2$(DataOutputStreamImplMixin $this) {
        return $this.setMaybeRelBitLimit0b$default$2();
    }

    @Override
    default public boolean setMaybeRelBitLimit0b$default$2() {
        return false;
    }

    public int bitStartOffset0b();

    public void bitStartOffset0b_$eq(int var1);

    public Object debugOutputStream();

    public void debugOutputStream_$eq(Object var1);

    public int org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByte_();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByte__$eq(int var1);

    public static int fragmentLastByte$(DataOutputStreamImplMixin $this) {
        return $this.fragmentLastByte();
    }

    default public int fragmentLastByte() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByte_();
    }

    public int org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByteLimit_();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByteLimit__$eq(int var1);

    public static int fragmentLastByteLimit$(DataOutputStreamImplMixin $this) {
        return $this.fragmentLastByteLimit();
    }

    default public int fragmentLastByteLimit() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByteLimit_();
    }

    public static void setFragmentLastByte$(DataOutputStreamImplMixin $this, int newFragmentByte, int nBitsInUse) {
        $this.setFragmentLastByte(newFragmentByte, nBitsInUse);
    }

    default public void setFragmentLastByte(int newFragmentByte, int nBitsInUse) {
        if (nBitsInUse < 0 || nBitsInUse > 7) {
            throw Assert$.MODULE$.usageError("nBitsInUse.>=(0).&&(nBitsInUse.<=(7))");
        }
        if (newFragmentByte < 0 || newFragmentByte > 255) {
            throw Assert$.MODULE$.usageError("newFragmentByte.>=(0).&&(newFragmentByte.<=(255))");
        }
        if (nBitsInUse == 0 && newFragmentByte != 0) {
            throw Assert$.MODULE$.usageError("newFragmentByte.==(0)");
        }
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByte__$eq(newFragmentByte);
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByteLimit__$eq(nBitsInUse);
    }

    public static boolean isEndOnByteBoundary$(DataOutputStreamImplMixin $this) {
        return $this.isEndOnByteBoundary();
    }

    default public boolean isEndOnByteBoundary() {
        return this.fragmentLastByteLimit() == 0;
    }

    public DOSState org$apache$daffodil$io$DataOutputStreamImplMixin$$_dosState();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$_dosState_$eq(DOSState var1);

    public static DOSState dosState$(DataOutputStreamImplMixin $this) {
        return $this.dosState();
    }

    default public DOSState dosState() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$_dosState();
    }

    public static void setDOSState$(DataOutputStreamImplMixin $this, DOSState newState) {
        $this.setDOSState(newState);
    }

    default public void setDOSState(DOSState newState) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$_dosState_$eq(newState);
    }

    public boolean isBuffering();

    public static boolean isDirect$(DataOutputStreamImplMixin $this) {
        return $this.isDirect();
    }

    default public boolean isDirect() {
        return !this.isBuffering();
    }

    public static boolean isDead$(DataOutputStreamImplMixin $this) {
        return $this.isDead();
    }

    default public boolean isDead() {
        DOSState dOSState = (DOSState)org.apache.daffodil.lib.equality.package$.MODULE$.TypeEqual(this.org$apache$daffodil$io$DataOutputStreamImplMixin$$_dosState());
        return package$TypeEqual$.MODULE$.$eq$colon$eq$extension(dOSState, Uninitialized$.MODULE$, package$TypeEquality$.MODULE$.rightSubtypeOfLeftEquality());
    }

    public static boolean isFinished$(DataOutputStreamImplMixin $this) {
        return $this.isFinished();
    }

    @Override
    default public boolean isFinished() {
        DOSState dOSState = (DOSState)org.apache.daffodil.lib.equality.package$.MODULE$.TypeEqual(this.org$apache$daffodil$io$DataOutputStreamImplMixin$$_dosState());
        return package$TypeEqual$.MODULE$.$eq$colon$eq$extension(dOSState, Finished$.MODULE$, package$TypeEquality$.MODULE$.rightSubtypeOfLeftEquality());
    }

    public static boolean isActive$(DataOutputStreamImplMixin $this) {
        return $this.isActive();
    }

    default public boolean isActive() {
        DOSState dOSState = (DOSState)org.apache.daffodil.lib.equality.package$.MODULE$.TypeEqual(this.org$apache$daffodil$io$DataOutputStreamImplMixin$$_dosState());
        return package$TypeEqual$.MODULE$.$eq$colon$eq$extension(dOSState, Active$.MODULE$, package$TypeEquality$.MODULE$.rightSubtypeOfLeftEquality());
    }

    public static boolean isReadOnly$(DataOutputStreamImplMixin $this) {
        return $this.isReadOnly();
    }

    default public boolean isReadOnly() {
        return this.isFinished() && this.isBuffering();
    }

    public static boolean isWritable$(DataOutputStreamImplMixin $this) {
        return $this.isWritable();
    }

    default public boolean isWritable() {
        return this.isActive() || this.isFinished() && this.isDirect();
    }

    public static boolean isReadable$(DataOutputStreamImplMixin $this) {
        return $this.isReadable();
    }

    default public boolean isReadable() {
        return !this.isDead();
    }

    public void setJavaOutputStream(OutputStream var1);

    public OutputStream getJavaOutputStream();

    public static DataOutputStreamImplMixin cst$(DataOutputStreamImplMixin $this) {
        return $this.cst();
    }

    @Override
    default public DataOutputStreamImplMixin cst() {
        return this;
    }

    public static void assignFrom$(DataOutputStreamImplMixin $this, DataOutputStreamImplMixin other) {
        $this.assignFrom(other);
    }

    default public void assignFrom(DataOutputStreamImplMixin other) {
        if (!this.isWritable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isWritable");
        }
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$super$assignFrom(other);
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b__$eq(other.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b_());
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits__$eq(other.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits_());
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$relBitPos0b__$eq(other.org$apache$daffodil$io$DataOutputStreamImplMixin$$relBitPos0b_());
        this.maybeAbsBitLimit0b_$eq(other.maybeAbsBitLimit0b());
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b__$eq(other.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b_());
        this.debugOutputStream_$eq(other.debugOutputStream());
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus__$eq(other.org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus_());
    }

    public static OutputStream realStream$(DataOutputStreamImplMixin $this) {
        return $this.realStream();
    }

    default public OutputStream realStream() {
        return this.getJavaOutputStream();
    }

    public static void setDebugging$(DataOutputStreamImplMixin $this, boolean setting) {
        $this.setDebugging(setting);
    }

    @Override
    default public void setDebugging(boolean setting) {
        if (!this.isWritable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isWritable");
        }
        if (setting) {
            if (this.areDebugging()) {
                throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.areDebugging.unary_!");
            }
            ByteArrayOutputStream dataCopyStream = new ByteArrayOutputStream();
            this.debugOutputStream_$eq(Maybe$One$.MODULE$.apply(dataCopyStream));
            TeeOutputStream teeStream = new TeeOutputStream(this.realStream(), (OutputStream)dataCopyStream);
            this.setJavaOutputStream((OutputStream)teeStream);
            this.cst().debugging_$eq(true);
            return;
        }
        this.cst().debugging_$eq(false);
        this.debugOutputStream_$eq(Maybe$.MODULE$.Nope());
    }

    public static boolean putBigInt$(DataOutputStreamImplMixin $this, BigInteger bigInt, int bitLengthFrom1, boolean signed, FormatInfo finfo) {
        return $this.putBigInt(bigInt, bitLengthFrom1, signed, finfo);
    }

    @Override
    default public boolean putBigInt(BigInteger bigInt, int bitLengthFrom1, boolean signed, FormatInfo finfo) {
        boolean bl;
        if (!this.isWritable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isWritable");
        }
        if (bitLengthFrom1 <= 0) {
            throw Assert$.MODULE$.usageError("bitLengthFrom1.>(0)");
        }
        if (!signed && (signed || bigInt.signum() < 0)) {
            throw Assert$.MODULE$.usageError("signed.||(signed.unary_!.&&(bigInt.signum().>=(0)))");
        }
        if (bitLengthFrom1 <= 64) {
            long longInt = bigInt.longValue();
            bl = this.putLongChecked(longInt, bitLengthFrom1, finfo);
        } else {
            Object object;
            byte[] array = bigInt.toByteArray();
            int numWholeBytesNeeded = (bitLengthFrom1 + 7) / 8;
            Object object2 = Predef$.MODULE$.byteArrayOps(array);
            if (ArrayOps$.MODULE$.size$extension(object2) > numWholeBytesNeeded) {
                Object object3;
                if (!signed && ArrayOps$.MODULE$.size$extension(object3 = Predef$.MODULE$.byteArrayOps(array)) == numWholeBytesNeeded + 1 && array[0] == 0) {
                    Object object4 = Predef$.MODULE$.byteArrayOps(array);
                    object = Maybe$One$.MODULE$.apply((byte[])ArrayOps$.MODULE$.tail$extension(object4));
                } else {
                    object = Maybe$.MODULE$.Nope();
                }
            } else {
                Object object5 = Predef$.MODULE$.byteArrayOps(array);
                if (ArrayOps$.MODULE$.size$extension(object5) < numWholeBytesNeeded) {
                    byte[] paddedArray = new byte[numWholeBytesNeeded];
                    Object object6 = Predef$.MODULE$.byteArrayOps(array);
                    int numPaddingBytes = numWholeBytesNeeded - ArrayOps$.MODULE$.size$extension(object6);
                    Object object7 = Predef$.MODULE$.byteArrayOps(array);
                    ArrayOps$.MODULE$.copyToArray$extension(object7, (Object)paddedArray, numPaddingBytes);
                    int sign = 0x80 & array[0];
                    if (sign > 0) {
                        if (bigInt.signum() >= 0) {
                            throw Assert$.MODULE$.abort("Invariant broken: bigInt.signum().<(0)");
                        }
                        for (int i = 0; i < numPaddingBytes; ++i) {
                            paddedArray[i] = (byte)255;
                        }
                    }
                    object = Maybe$One$.MODULE$.apply(paddedArray);
                } else {
                    int fragBits = bitLengthFrom1 % 8;
                    if (fragBits == 0) {
                        object = Maybe$One$.MODULE$.apply(array);
                    } else {
                        int shifted = array[0] >> fragBits - 1;
                        int signBit = shifted & 1;
                        int signExtendedBits = shifted >> 1;
                        object = signBit == 1 && signExtendedBits != -1 || signBit == 0 && signExtendedBits != 0 ? Maybe$.MODULE$.Nope() : Maybe$One$.MODULE$.apply(array);
                    }
                }
            }
            Object maybeArrayToPut = object;
            bl = Maybe$.MODULE$.isDefined$extension(maybeArrayToPut) ? this.putByteArray((byte[])Maybe$.MODULE$.get$extension(maybeArrayToPut), Int$.MODULE$.int2long(bitLengthFrom1), finfo, this.putByteArray$default$4()) : false;
        }
        boolean res = bl;
        return res;
    }

    public static boolean putByteArray$(DataOutputStreamImplMixin $this, byte[] array, long bitLengthFrom1, FormatInfo finfo, boolean ignoreByteOrder) {
        return $this.putByteArray(array, bitLengthFrom1, finfo, ignoreByteOrder);
    }

    @Override
    default public boolean putByteArray(byte[] array, long bitLengthFrom1, FormatInfo finfo, boolean ignoreByteOrder) {
        boolean bl;
        if (bitLengthFrom1 < 1L || bitLengthFrom1 > (long)Integer.MAX_VALUE * 8L) {
            throw Assert$.MODULE$.usageError("bitLengthFrom1.>=(1).&&(bitLengthFrom1.<=(scala.Int.MaxValue.toLong.*(8)))");
        }
        if (!this.isWritable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isWritable");
        }
        if (MaybeULong$.MODULE$.isDefined$extension(this.maybeRelBitLimit0b()) && MaybeULong$.MODULE$.get$extension(this.maybeRelBitLimit0b()) < ULong$.MODULE$.$plus$extension(this.relBitPos0b(), bitLengthFrom1, DummyImplicit$.MODULE$.dummyImplicit())) {
            bl = false;
        } else {
            byte[] byArray;
            ByteOrder byteOrder;
            int bytesToPutFromArray = (int)((bitLengthFrom1 + 7L) / 8L);
            if (bitLengthFrom1 > 8L && package$TypeEqual$.MODULE$.$eq$colon$eq$extension(byteOrder = (ByteOrder)org.apache.daffodil.lib.equality.package$.MODULE$.TypeEqual(finfo.byteOrder()), ByteOrder$LittleEndian$.MODULE$, package$TypeEquality$.MODULE$.rightSubtypeOfLeftEquality()) && !ignoreByteOrder) {
                byte[] reversedArray = new byte[bytesToPutFromArray];
                for (int index = 0; index < bytesToPutFromArray; ++index) {
                    reversedArray[index] = array[bytesToPutFromArray - 1 - index];
                }
                byArray = reversedArray;
            } else {
                byArray = array;
            }
            byte[] bytes = byArray;
            int newFragmentByteLimit = (int)(((long)this.fragmentLastByteLimit() + bitLengthFrom1) % 8L);
            int newFragmentByte = 0;
            if (this.fragmentLastByteLimit() == 0) {
                int fullBytes = (int)(bitLengthFrom1 / 8L);
                this.realStream().write(bytes, 0, fullBytes);
                if (newFragmentByteLimit > 0) {
                    newFragmentByte = Bits$.MODULE$.asUnsignedByte(bytes[fullBytes]);
                }
            } else {
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder$MostSignificantBitFirst$ bitOrder$MostSignificantBitFirst$ = BitOrder$MostSignificantBitFirst$.MODULE$;
                boolean isMSBF = !(bitOrder != null ? !bitOrder.equals(bitOrder$MostSignificantBitFirst$) : bitOrder$MostSignificantBitFirst$ != null);
                int fragByteMask = isMSBF ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(this.fragmentLastByteLimit())) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(this.fragmentLastByteLimit()));
                int curByteMask = ~fragByteMask & 0xFF;
                int fragShift = 8 - this.fragmentLastByteLimit();
                int curShift = this.fragmentLastByteLimit();
                long fragmentBitsInArray = bitLengthFrom1 % 8L;
                long bitsAvailableInLastByte = fragmentBitsInArray == 0L ? 8L : fragmentBitsInArray;
                boolean lastIndexCreatesFullByte = (long)this.fragmentLastByteLimit() + bitsAvailableInLastByte >= 8L;
                int lastIndex = bytesToPutFromArray - 1;
                newFragmentByte = this.fragmentLastByte();
                for (int index = 0; index < bytesToPutFromArray; ++index) {
                    int newByte;
                    int curByte = Bits$.MODULE$.asUnsignedByte(bytes[index]);
                    int n = newByte = isMSBF ? (curByte & curByteMask) >> curShift | newFragmentByte : (curByte & curByteMask) << curShift | newFragmentByte;
                    if (index != lastIndex || lastIndexCreatesFullByte) {
                        this.realStream().write(Byte$.MODULE$.byte2int(Bits$.MODULE$.asSignedByte(Int$.MODULE$.int2long(newByte))));
                        if (isMSBF) {
                            newFragmentByte = (curByte & fragByteMask) << fragShift;
                            continue;
                        }
                        newFragmentByte = (curByte & fragByteMask) >> fragShift;
                        continue;
                    }
                    newFragmentByte = newByte;
                }
            }
            if (newFragmentByteLimit > 0) {
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder$MostSignificantBitFirst$ bitOrder$MostSignificantBitFirst$ = BitOrder$MostSignificantBitFirst$.MODULE$;
                int mask = !(bitOrder != null ? !bitOrder.equals(bitOrder$MostSignificantBitFirst$) : bitOrder$MostSignificantBitFirst$ != null) ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(newFragmentByteLimit)) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(newFragmentByteLimit));
                this.setFragmentLastByte(newFragmentByte & mask, newFragmentByteLimit);
            } else {
                this.setFragmentLastByte(0, 0);
            }
            this.setRelBitPos0b(ULong$.MODULE$.$plus$extension(this.relBitPos0b(), ULong$.MODULE$.apply(bitLengthFrom1)));
            this.setNonZeroLength();
            bl = true;
        }
        boolean res = bl;
        return res;
    }

    public static boolean putByteArray$default$4$(DataOutputStreamImplMixin $this) {
        return $this.putByteArray$default$4();
    }

    @Override
    default public boolean putByteArray$default$4() {
        return false;
    }

    private boolean exceedsBitLimit(long lengthInBytes) {
        long relEndBitPos0b = ULong$.MODULE$.$plus$extension(this.relBitPos0b(), ULong$.MODULE$.apply(lengthInBytes * 8L));
        return MaybeULong$.MODULE$.isDefined$extension(this.maybeRelBitLimit0b()) && ULong$.MODULE$.$greater$extension(relEndBitPos0b, MaybeULong$.MODULE$.getULong$extension(this.maybeRelBitLimit0b()));
    }

    public static long putBytes$(DataOutputStreamImplMixin $this, byte[] ba, int byteStartOffset0b, int lengthInBytes, FormatInfo finfo) {
        return $this.putBytes(ba, byteStartOffset0b, lengthInBytes, finfo);
    }

    default public long putBytes(byte[] ba, int byteStartOffset0b, int lengthInBytes, FormatInfo finfo) {
        if (!this.isWritable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isWritable");
        }
        if (this.isEndOnByteBoundary()) {
            long l;
            if (this.exceedsBitLimit(Int$.MODULE$.int2long(lengthInBytes))) {
                long n = ULong$.MODULE$.$div$extension(ULong$.MODULE$.$minus$extension(MaybeULong$.MODULE$.getULong$extension(this.maybeRelBitLimit0b()), this.relBitPos0b()), 8, DummyImplicit$.MODULE$.dummyImplicit());
                if (n < 0L) {
                    throw Assert$.MODULE$.abort("Invariant broken: n.>=(0)");
                }
                l = n;
            } else {
                l = Int$.MODULE$.int2long(lengthInBytes);
            }
            long nBytes = l;
            this.realStream().write(ba, byteStartOffset0b, (int)nBytes);
            this.setRelBitPos0b(ULong$.MODULE$.$plus$extension(this.relBitPos0b(), ULong$.MODULE$.apply(nBytes * 8L)));
            if (lengthInBytes > 0) {
                this.setNonZeroLength();
            }
            return nBytes;
        }
        int i = 0;
        boolean bl = true;
        while (i < lengthInBytes && bl) {
            bl = this.putLongUnchecked(Int$.MODULE$.int2long(Bits$.MODULE$.asUnsignedByte(ba[i])), 8, finfo, this.putLongUnchecked$default$4());
            if (!bl) continue;
            ++i;
        }
        return Int$.MODULE$.int2long(i);
    }

    public static long putFile$(DataOutputStreamImplMixin $this, Path path, long lengthInBits, int chunkSizeInBytes, FormatInfo finfo) {
        return $this.putFile(path, lengthInBits, chunkSizeInBytes, finfo);
    }

    default public long putFile(Path path, long lengthInBits, int chunkSizeInBytes, FormatInfo finfo) {
        InputStream inputStream;
        try {
            inputStream = Files.newInputStream(path, StandardOpenOption.READ);
        }
        catch (Exception e) {
            throw new FileIOException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unable to open file %s for reading: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{path.toString(), e.getMessage()})));
        }
        InputStream fileStream = inputStream;
        byte[] array = new byte[chunkSizeInBytes];
        int chunkSizeInBits = chunkSizeInBytes * 8;
        long remainingBitsToPut = lengthInBits;
        boolean fileHasData = true;
        long bitsWritten = 0L;
        while (remainingBitsToPut > 0L && fileHasData) {
            long bitsToRead = Math.min(remainingBitsToPut, Int$.MODULE$.int2long(chunkSizeInBits));
            long bytesToRead = (bitsToRead + 7L) / 8L;
            int bytesRead = fileStream.read(array, 0, (int)bytesToRead);
            if (bytesRead == -1) {
                fileHasData = false;
                continue;
            }
            long bitsToPut = Math.min(Int$.MODULE$.int2long(bytesRead * 8), bitsToRead);
            boolean ret = this.putByteArray(array, Int$.MODULE$.int2long((int)bitsToPut), finfo, true);
            if (!ret) {
                fileStream.close();
                throw new FileIOException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Failed to write file data: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{path.toString()})));
            }
            bitsWritten += bitsToPut;
            remainingBitsToPut -= bitsToPut;
        }
        fileStream.close();
        long nFillBits = remainingBitsToPut;
        if (nFillBits > 0L) {
            boolean ret = this.skip(nFillBits, finfo);
            if (!ret) {
                throw Assert$.MODULE$.abort("Invariant broken: ret");
            }
            bitsWritten += nFillBits;
        }
        return bitsWritten;
    }

    public static long putBytes$(DataOutputStreamImplMixin $this, byte[] ba, FormatInfo finfo) {
        return $this.putBytes(ba, finfo);
    }

    default public long putBytes(byte[] ba, FormatInfo finfo) {
        return this.putBytes(ba, 0, ba.length, finfo);
    }

    public static long putBitBuffer$(DataOutputStreamImplMixin $this, ByteBuffer bb, long lengthInBits, FormatInfo finfo) {
        return $this.putBitBuffer(bb, lengthInBits, finfo);
    }

    default public long putBitBuffer(ByteBuffer bb, long lengthInBits, FormatInfo finfo) {
        long res;
        if ((long)(bb.remaining() * 8) < lengthInBits) {
            throw Assert$.MODULE$.usageError("bb.remaining().*(8).>=(lengthInBits)");
        }
        int nWholeBytes = (int)(lengthInBits / 8L);
        int nFragBits = (int)(lengthInBits % 8L);
        int numBytesForLengthInBits = nWholeBytes + (nFragBits > 0 ? 1 : 0);
        if (bb.remaining() != numBytesForLengthInBits) {
            throw Assert$.MODULE$.usageError("bb.remaining().==(numBytesForLengthInBits)");
        }
        if (nFragBits > 0) {
            bb.limit(bb.limit() - 1);
        }
        long nBytesWritten = this.putByteBuffer(bb, finfo);
        long nBitsWritten = nBytesWritten * 8L;
        if (nBytesWritten < (long)nWholeBytes) {
            v0 = nBytesWritten * 8L;
        } else {
            boolean bl;
            if (nFragBits > 0) {
                bb.limit(bb.limit() + 1);
                long fragByte = Int$.MODULE$.int2long(Bits$.MODULE$.asUnsignedByte(bb.get(bb.limit() - 1)));
                if (finfo.bitOrder() == BitOrder$MostSignificantBitFirst$.MODULE$) {
                    fragByte >>>= 8 - nFragBits;
                }
                bl = this.putLongChecked(fragByte, nFragBits, finfo);
            } else {
                bl = true;
            }
            boolean isFragWritten = bl;
            v0 = res = isFragWritten ? nBitsWritten + (long)nFragBits : nBitsWritten;
        }
        if (res > 0L) {
            this.setNonZeroLength();
        }
        return res;
    }

    private long putByteBuffer(ByteBuffer bb, FormatInfo finfo) {
        long nTransferred;
        if (!this.isWritable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isWritable");
        }
        if (bb.hasArray()) {
            v0 = this.putBytes(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining(), finfo);
        } else if (this.isEndOnByteBoundary()) {
            int lengthInBytes = bb.remaining();
            if (this.exceedsBitLimit(Int$.MODULE$.int2long(lengthInBytes))) {
                return 0L;
            }
            WritableByteChannel chan = Channels.newChannel(this.realStream());
            this.setRelBitPos0b(ULong$.MODULE$.$plus$extension(this.relBitPos0b(), ULong$.MODULE$.apply(Int$.MODULE$.int2long(lengthInBytes * 8))));
            v0 = Int$.MODULE$.int2long(chan.write(bb));
        } else {
            int i = 0;
            boolean bl = true;
            int limit = bb.remaining();
            while (i < limit && bl) {
                bl = this.putLongChecked(Int$.MODULE$.int2long(Bits$.MODULE$.asUnsignedByte(bb.get(i))), 8, finfo);
                if (!bl) continue;
                ++i;
            }
            v0 = nTransferred = Int$.MODULE$.int2long(i);
        }
        if (nTransferred > 0L) {
            this.setNonZeroLength();
        }
        return nTransferred;
    }

    public static long putString$(DataOutputStreamImplMixin $this, String str, FormatInfo finfo) {
        return $this.putString(str, finfo);
    }

    @Override
    default public long putString(String str, FormatInfo finfo) {
        if (!this.isWritable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isWritable");
        }
        return BoxesRunTime.unboxToLong(this.withLocalCharBuffer().apply((Function1 & Serializable)lcb -> {
            CharBuffer cb = (CharBuffer)lcb.getBuf(Int$.MODULE$.int2long(str.length()));
            cb.append(str);
            cb.flip();
            return this.putCharBuffer(cb, finfo);
        }));
    }

    public static long putCharBuffer$(DataOutputStreamImplMixin $this, CharBuffer cb, FormatInfo finfo) {
        return $this.putCharBuffer(cb, finfo);
    }

    @Override
    default public long putCharBuffer(CharBuffer cb, FormatInfo finfo) {
        if (!this.isWritable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isWritable");
        }
        int nToTransfer = cb.remaining();
        int res = BoxesRunTime.unboxToInt(this.withLocalByteBuffer().apply((Function1 & Serializable)lbb -> {
            int bitsToWrite;
            ByteBuffer bb;
            block12: {
                CoderResult coderResult;
                CoderResult cr;
                block13: {
                    CoderResult coderResult2;
                    CoderResult coderResult3;
                    block11: {
                        long nBytes = (long)package$.MODULE$.ceil(Float$.MODULE$.float2double((float)cb.remaining() * finfo.encoder().maxBytesPerChar()));
                        bb = (ByteBuffer)lbb.getBuf(nBytes);
                        coderResult = cr = finfo.encoder().encode(cb, bb, true);
                        coderResult3 = CoderResult.UNDERFLOW;
                        coderResult2 = coderResult;
                        if (coderResult3 != null) break block11;
                        if (coderResult2 == null) break block12;
                        break block13;
                    }
                    if (coderResult3.equals(coderResult2)) break block12;
                }
                CoderResult coderResult4 = CoderResult.OVERFLOW;
                CoderResult coderResult5 = coderResult;
                if (!(coderResult4 != null ? !coderResult4.equals(coderResult5) : coderResult5 != null)) {
                    throw Assert$.MODULE$.invariantFailed("byte buffer wasn't big enough to accomodate the string");
                }
                if (cr.isMalformed()) {
                    cr.throwException();
                } else if (cr.isUnmappable()) {
                    cr.throwException();
                } else {
                    throw new MatchError((Object)coderResult);
                }
            }
            bb.flip();
            BitsCharsetEncoder bitsCharsetEncoder = finfo.encoder();
            if (bitsCharsetEncoder instanceof BitsCharsetNonByteSizeEncoder) {
                BitsCharsetNonByteSizeEncoder encoderWithBits = (BitsCharsetNonByteSizeEncoder)bitsCharsetEncoder;
                v2 = encoderWithBits.bitsCharset().bitWidthOfACodeUnit() * nToTransfer;
            } else {
                v2 = bitsToWrite = bb.remaining() * 8;
            }
            if (this.putBitBuffer(bb, Int$.MODULE$.int2long(bitsToWrite), finfo) == 0L) {
                return 0;
            }
            return nToTransfer;
        }));
        if (res > 0) {
            this.setNonZeroLength();
        }
        return Int$.MODULE$.int2long(res);
    }

    public static boolean putLongChecked$(DataOutputStreamImplMixin $this, long signedLong, int bitLengthFrom1To64, FormatInfo finfo) {
        return $this.putLongChecked(signedLong, bitLengthFrom1To64, finfo);
    }

    default public boolean putLongChecked(long signedLong, int bitLengthFrom1To64, FormatInfo finfo) {
        if (bitLengthFrom1To64 < 1 || bitLengthFrom1To64 > 64) {
            throw Assert$.MODULE$.usageError("bitLengthFrom1To64.>=(1).&&(bitLengthFrom1To64.<=(64))");
        }
        if (!this.isWritable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isWritable");
        }
        if (MaybeULong$.MODULE$.isDefined$extension(this.maybeRelBitLimit0b()) && MaybeULong$.MODULE$.get$extension(this.maybeRelBitLimit0b()) < ULong$.MODULE$.$plus$extension(this.relBitPos0b(), bitLengthFrom1To64, DummyImplicit$.MODULE$.dummyImplicit())) {
            return false;
        }
        return this.putLongUnchecked(signedLong, bitLengthFrom1To64, finfo, this.putLongUnchecked$default$4());
    }

    public static boolean putLongUnchecked$(DataOutputStreamImplMixin $this, long signedLong, int bitLengthFrom1To64, FormatInfo finfo, boolean ignoreByteOrder) {
        return $this.putLongUnchecked(signedLong, bitLengthFrom1To64, finfo, ignoreByteOrder);
    }

    default public boolean putLongUnchecked(long signedLong, int bitLengthFrom1To64, FormatInfo finfo, boolean ignoreByteOrder) {
        boolean res;
        boolean bl = finfo.bitOrder() == BitOrder$MostSignificantBitFirst$.MODULE$ && !ignoreByteOrder ? (finfo.byteOrder() == ByteOrder$BigEndian$.MODULE$ ? this.putLong_BE_MSBFirst(signedLong, bitLengthFrom1To64) : this.putLong_LE_MSBFirst(signedLong, bitLengthFrom1To64)) : (res = this.putLong_LE_LSBFirst(signedLong, bitLengthFrom1To64));
        if (res) {
            this.setRelBitPos0b(ULong$.MODULE$.$plus$extension(this.relBitPos0b(), ULong$.MODULE$.apply(Int$.MODULE$.int2long(bitLengthFrom1To64))));
            this.setNonZeroLength();
        }
        return res;
    }

    public static boolean putLongUnchecked$default$4$(DataOutputStreamImplMixin $this) {
        return $this.putLongUnchecked$default$4();
    }

    default public boolean putLongUnchecked$default$4() {
        return false;
    }

    public boolean putLong_BE_MSBFirst(long var1, int var3);

    public boolean putLong_LE_MSBFirst(long var1, int var3);

    public boolean putLong_LE_LSBFirst(long var1, int var3);

    public ByteBuffer unionByteBuffer();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$unionByteBuffer_$eq(ByteBuffer var1);

    public DoubleBuffer org$apache$daffodil$io$DataOutputStreamImplMixin$$unionDoubleBuffer();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$org$apache$daffodil$io$DataOutputStreamImplMixin$$unionDoubleBuffer_$eq(DoubleBuffer var1);

    public FloatBuffer org$apache$daffodil$io$DataOutputStreamImplMixin$$unionFloatBuffer();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$org$apache$daffodil$io$DataOutputStreamImplMixin$$unionFloatBuffer_$eq(FloatBuffer var1);

    public IntBuffer org$apache$daffodil$io$DataOutputStreamImplMixin$$unionIntBuffer();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$org$apache$daffodil$io$DataOutputStreamImplMixin$$unionIntBuffer_$eq(IntBuffer var1);

    public LongBuffer unionLongBuffer();

    public void org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$unionLongBuffer_$eq(LongBuffer var1);

    public static boolean putBinaryFloat$(DataOutputStreamImplMixin $this, float v, FormatInfo finfo) {
        return $this.putBinaryFloat(v, finfo);
    }

    @Override
    default public boolean putBinaryFloat(float v, FormatInfo finfo) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$unionFloatBuffer().put(0, v);
        int i = this.org$apache$daffodil$io$DataOutputStreamImplMixin$$unionIntBuffer().get(0);
        boolean res = this.putLongChecked(Int$.MODULE$.int2long(i), 32, finfo);
        return res;
    }

    public static boolean putBinaryDouble$(DataOutputStreamImplMixin $this, double v, FormatInfo finfo) {
        return $this.putBinaryDouble(v, finfo);
    }

    @Override
    default public boolean putBinaryDouble(double v, FormatInfo finfo) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$unionDoubleBuffer().put(0, v);
        long l = this.unionLongBuffer().get(0);
        boolean res = this.putLongChecked(l, 64, finfo);
        return res;
    }

    private long fillLong(byte fillByte) {
        long fl = 0L;
        int fb = fillByte & 0xFF;
        fl = (fl << 8) + (long)fb;
        fl = (fl << 8) + (long)fb;
        fl = (fl << 8) + (long)fb;
        fl = (fl << 8) + (long)fb;
        fl = (fl << 8) + (long)fb;
        fl = (fl << 8) + (long)fb;
        fl = (fl << 8) + (long)fb;
        fl = (fl << 8) + (long)fb;
        return fl;
    }

    public static boolean skip$(DataOutputStreamImplMixin $this, long nBits, FormatInfo finfo) {
        return $this.skip(nBits, finfo);
    }

    @Override
    default public boolean skip(long nBits, FormatInfo finfo) {
        boolean isFinalFragDone;
        if (!this.isWritable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isWritable");
        }
        if (MaybeULong$.MODULE$.isDefined$extension(this.maybeRelBitLimit0b())) {
            long lim = MaybeULong$.MODULE$.getULong$extension(this.maybeRelBitLimit0b());
            if (ULong$.MODULE$.$greater$extension(ULong$.MODULE$.$plus$extension(this.relBitPos0b(), ULong$.MODULE$.apply(nBits)), lim)) {
                return false;
            }
        }
        if (nBits <= 64L) {
            byte fb = finfo.fillByte();
            long lng = this.fillLong(fb);
            return this.putLongUnchecked(lng, (int)nBits, finfo, this.putLongUnchecked$default$4());
        }
        long nBitsRemaining = nBits;
        if (this.fragmentLastByteLimit() > 0) {
            int numRemainingFragmentBits = 8 - this.fragmentLastByteLimit();
            boolean isInitialFragDone = this.putLongUnchecked(Byte$.MODULE$.byte2long(finfo.fillByte()), numRemainingFragmentBits, finfo, this.putLongUnchecked$default$4());
            if (!isInitialFragDone) {
                throw Assert$.MODULE$.abort("Invariant broken: isInitialFragDone");
            }
            nBitsRemaining -= (long)numRemainingFragmentBits;
            if (this.fragmentLastByteLimit() != 0) {
                throw Assert$.MODULE$.abort("Invariant broken: DataOutputStreamImplMixin.this.fragmentLastByteLimit.==(0)");
            }
        }
        long nBytes = nBitsRemaining / 8L;
        while (nBytes > 0L) {
            --nBytes;
            this.setRelBitPos0b(ULong$.MODULE$.$plus$extension(this.relBitPos0b(), ULong$.MODULE$.apply(8L)));
            this.realStream().write(Byte$.MODULE$.byte2int(finfo.fillByte()));
            nBitsRemaining -= 8L;
        }
        if (nBitsRemaining >= 8L) {
            throw Assert$.MODULE$.abort("Invariant broken: nBitsRemaining.<(8)");
        }
        if (nBitsRemaining > 0L && !(isFinalFragDone = this.putLongUnchecked(Byte$.MODULE$.byte2long(finfo.fillByte()), (int)nBitsRemaining, finfo, this.putLongUnchecked$default$4()))) {
            throw Assert$.MODULE$.abort("Invariant broken: isFinalFragDone");
        }
        this.setNonZeroLength();
        return true;
    }

    public static ByteBuffer futureData$(DataOutputStreamImplMixin $this, int nBytesRequested) {
        return $this.futureData(nBytesRequested);
    }

    @Override
    default public ByteBuffer futureData(int nBytesRequested) {
        if (!this.isReadable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isReadable");
        }
        return ByteBuffer.allocate(0);
    }

    public static ByteBuffer pastData$(DataOutputStreamImplMixin $this, int nBytesRequested) {
        return $this.pastData(nBytesRequested);
    }

    @Override
    default public ByteBuffer pastData(int nBytesRequested) {
        if (!this.isReadable() && !this.areDebugging()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isReadable.||(DataOutputStreamImplMixin.this.areDebugging)");
        }
        if (nBytesRequested < 0) {
            throw Assert$.MODULE$.usageError("nBytesRequested.>=(0)");
        }
        if (BoxesRunTime.equals((Object)this.debugOutputStream(), (Object)Maybe$.MODULE$.Nope())) {
            return ByteBuffer.allocate(0);
        }
        Object object = this.debugOutputStream();
        byte[] arr = ((ByteArrayOutputStream)Maybe$.MODULE$.get$extension(object)).toByteArray();
        ByteBuffer bb = ByteBuffer.wrap(arr);
        int sz = package$.MODULE$.max(0, arr.length - nBytesRequested);
        bb.limit(arr.length);
        bb.position(sz);
        return bb;
    }

    public static void resetMaybeRelBitLimit0b$(DataOutputStreamImplMixin $this, long savedBitLimit0b) {
        $this.resetMaybeRelBitLimit0b(savedBitLimit0b);
    }

    @Override
    default public void resetMaybeRelBitLimit0b(long savedBitLimit0b) {
        if (!this.isWritable()) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.isWritable");
        }
        this.setMaybeRelBitLimit0b(savedBitLimit0b, true);
    }

    public static boolean isAligned$(DataOutputStreamImplMixin $this, int bitAlignment1b) {
        return $this.isAligned(bitAlignment1b);
    }

    @Override
    default public boolean isAligned(int bitAlignment1b) {
        if (bitAlignment1b < 1) {
            throw Assert$.MODULE$.usageError("bitAlignment1b.>=(1)");
        }
        Integer n = (Integer)org.apache.daffodil.lib.equality.package$.MODULE$.ViewEqual(BoxesRunTime.boxToInteger((int)bitAlignment1b));
        if (package$ViewEqual$.MODULE$.$eq$hash$eq$extension(n, BoxesRunTime.boxToInteger((int)1))) {
            return true;
        }
        if (!MaybeULong$.MODULE$.isDefined$extension(this.maybeAbsBitPos0b())) {
            throw Assert$.MODULE$.usageError("DataOutputStreamImplMixin.this.maybeAbsBitPos0b.isDefined");
        }
        long alignment = MaybeULong$.MODULE$.get$extension(this.maybeAbsBitPos0b()) % (long)bitAlignment1b;
        boolean res = alignment == 0L;
        return res;
    }

    public static boolean align$(DataOutputStreamImplMixin $this, int bitAlignment1b, FormatInfo finfo) {
        return $this.align(bitAlignment1b, finfo);
    }

    @Override
    default public boolean align(int bitAlignment1b, FormatInfo finfo) {
        if (this.isAligned(bitAlignment1b)) {
            return true;
        }
        long deltaBits = (long)bitAlignment1b - MaybeULong$.MODULE$.get$extension(this.maybeAbsBitPos0b()) % (long)bitAlignment1b;
        return this.skip(deltaBits, finfo);
    }
}

