/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.StringElaborator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class Name_1
extends ScalarSystemFunction {
    @Override
    public StringValue evaluate(Item item, XPathContext context) throws XPathException {
        return StringValue.makeStringValue(((NodeInfo)item).getDisplayName());
    }

    @Override
    public Sequence resultWhenEmpty() {
        return StringValue.EMPTY_STRING;
    }

    @Override
    public Elaborator getElaborator() {
        return new NameElaborator();
    }

    public static class NameElaborator
    extends StringElaborator {
        @Override
        public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthIfAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            boolean nullable = Cardinality.allowsZero(arg.getCardinality());
            ItemEvaluator argEval = arg.makeElaborator().elaborateForItem();
            if (nullable) {
                return context -> {
                    NodeInfo node = (NodeInfo)argEval.eval(context);
                    if (node == null) {
                        return EmptyUnicodeString.getInstance();
                    }
                    return StringView.of(node.getDisplayName());
                };
            }
            return context -> StringView.of(((NodeInfo)argEval.eval(context)).getDisplayName());
        }

        @Override
        public StringEvaluator elaborateForString(boolean zeroLengthIfAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            boolean nullable = Cardinality.allowsZero(arg.getCardinality());
            ItemEvaluator argEval = arg.makeElaborator().elaborateForItem();
            if (nullable) {
                return context -> {
                    NodeInfo node = (NodeInfo)argEval.eval(context);
                    if (node == null) {
                        return "";
                    }
                    return node.getDisplayName();
                };
            }
            return context -> ((NodeInfo)argEval.eval(context)).getDisplayName();
        }
    }
}

