/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllDirectDoublesSketch;
import org.apache.datasketches.kll.KllDoublesHelper;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHeapDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.quantilescommon.DoublesSketchSortedView;
import org.apache.datasketches.quantilescommon.DoublesSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllMiscDoublesTest {
    private static final boolean enablePrinting = false;

    @Test
    public void checkSortedViewConstruction() {
        KllDoublesSketch kll = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 20; ++i) {
            kll.update((double)i);
        }
        DoublesSketchSortedView fsv = kll.getSortedView();
        long[] cumWeights = fsv.getCumulativeWeights();
        double[] values = fsv.getQuantiles();
        Assert.assertEquals((int)cumWeights.length, (int)20);
        Assert.assertEquals((int)values.length, (int)20);
        for (int i = 0; i < 20; ++i) {
            Assert.assertEquals((long)cumWeights[i], (long)(i + 1));
            Assert.assertEquals((double)values[i], (double)(i + 1));
        }
    }

    @Test
    public void checkBounds() {
        KllDoublesSketch kll = KllDoublesSketch.newHeapInstance();
        for (int i = 0; i < 1000; ++i) {
            kll.update((double)i);
        }
        double eps = kll.getNormalizedRankError(false);
        double est = kll.getQuantile(0.5);
        double ub = kll.getQuantileUpperBound(0.5);
        double lb = kll.getQuantileLowerBound(0.5);
        Assert.assertEquals((double)ub, (double)kll.getQuantile(0.5 + eps));
        Assert.assertEquals((double)lb, (double)kll.getQuantile(0.5 - eps));
        KllMiscDoublesTest.println("Ext     : " + est);
        KllMiscDoublesTest.println("UB      : " + ub);
        KllMiscDoublesTest.println("LB      : " + lb);
        double rest = kll.getRank(est);
        double restUB = kll.getRankUpperBound(rest);
        double restLB = kll.getRankLowerBound(rest);
        Assert.assertTrue((restUB - rest < 2.0 * eps ? 1 : 0) != 0);
        Assert.assertTrue((rest - restLB < 2.0 * eps ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions1() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        MemorySegment wseg = MemorySegment.ofArray(sk.toByteArray());
        wseg.set(ValueLayout.JAVA_BYTE, 6L, (byte)3);
        KllDoublesSketch.heapify((MemorySegment)wseg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions2() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        MemorySegment wseg = MemorySegment.ofArray(sk.toByteArray());
        wseg.set(ValueLayout.JAVA_BYTE, 0L, (byte)1);
        KllDoublesSketch.heapify((MemorySegment)wseg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions3() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        sk.update(1.0);
        sk.update(2.0);
        MemorySegment wseg = MemorySegment.ofArray(sk.toByteArray());
        wseg.set(ValueLayout.JAVA_BYTE, 0L, (byte)1);
        KllDoublesSketch.heapify((MemorySegment)wseg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions4() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        MemorySegment wseg = MemorySegment.ofArray(sk.toByteArray());
        wseg.set(ValueLayout.JAVA_BYTE, 1L, (byte)0);
        KllDoublesSketch.heapify((MemorySegment)wseg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions5() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        MemorySegment wseg = MemorySegment.ofArray(sk.toByteArray());
        wseg.set(ValueLayout.JAVA_BYTE, 2L, (byte)0);
        KllDoublesSketch.heapify((MemorySegment)wseg);
    }

    @Test
    public void checkMisc() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)8);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        KllMiscDoublesTest.println(sk.toString(true, true));
        for (int i = 0; i < 20; ++i) {
            sk.update((double)i);
        }
        KllMiscDoublesTest.println(sk.toString(true, true));
        sk.toByteArray();
        double[] items = sk.getDoubleItemsArray();
        Assert.assertEquals((int)items.length, (int)16);
        int[] levels = sk.getLevelsArray(sk.sketchStructure);
        Assert.assertEquals((int)levels.length, (int)3);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
    }

    @Test
    public void visualCheckToString() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        int n = 21;
        for (int i = 1; i <= n; ++i) {
            sk.update((double)i);
        }
        KllMiscDoublesTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)20);
        n = 400;
        for (int i = 101; i <= n + 100; ++i) {
            sk2.update((double)i);
        }
        KllMiscDoublesTest.println(Util.LS + sk2.toString(true, true));
        Assert.assertEquals((int)sk2.getNumLevels(), (int)5);
        Assert.assertEquals((double)sk2.getMinItem(), (double)101.0);
        Assert.assertEquals((double)sk2.getMaxItem(), (double)500.0);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)52);
        sk2.merge((KllSketch)sk);
        KllMiscDoublesTest.println(Util.LS + sk2.toString(true, true));
        Assert.assertEquals((int)sk2.getNumLevels(), (int)5);
        Assert.assertEquals((double)sk2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxItem(), (double)500.0);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)56);
    }

    @Test
    public void viewHeapCompactions() {
        int k = 20;
        int n = 108;
        boolean withLevels = false;
        boolean withLevelsAndItems = true;
        int compaction = 0;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 108; ++i) {
            sk.update((double)i);
            if (sk.levelsArr[0] != 0) continue;
            KllMiscDoublesTest.println(Util.LS + "#<<< BEFORE COMPACTION # " + ++compaction + " >>>");
            KllMiscDoublesTest.println(sk.toString(false, true));
            sk.update((double)(++i));
            KllMiscDoublesTest.println(Util.LS + "#<<< AFTER COMPACTION  # " + compaction + " >>>");
            KllMiscDoublesTest.println(sk.toString(false, true));
            Assert.assertEquals((double)sk.getDoubleItemsArray()[sk.levelsArr[0]], (double)i);
        }
        KllMiscDoublesTest.println(Util.LS + "#<<< END STATE # >>>");
        KllMiscDoublesTest.println(sk.toString(false, true));
        KllMiscDoublesTest.println("");
    }

    @Test
    public void viewDirectCompactions() {
        int k = 20;
        int n = 108;
        boolean withLevels = false;
        boolean withLevelsAndItems = true;
        int compaction = 0;
        int sizeBytes = KllSketch.getMaxSerializedSizeBytes((int)20, (long)108L, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        MemorySegment wseg = MemorySegment.ofArray(new byte[sizeBytes]);
        KllDoublesSketch sk = KllDoublesSketch.newDirectInstance((int)20, (MemorySegment)wseg, null);
        for (int i = 1; i <= 108; ++i) {
            sk.update((double)i);
            if (sk.levelsArr[0] != 0) continue;
            KllMiscDoublesTest.println(Util.LS + "#<<< BEFORE COMPACTION # " + ++compaction + " >>>");
            KllMiscDoublesTest.println(sk.toString(false, true));
            sk.update((double)(++i));
            KllMiscDoublesTest.println(Util.LS + "#<<< AFTER COMPACTION  # " + compaction + " >>>");
            KllMiscDoublesTest.println(sk.toString(false, true));
            Assert.assertEquals((double)sk.getDoubleItemsArray()[sk.levelsArr[0]], (double)i);
        }
        KllMiscDoublesTest.println(Util.LS + "#<<< END STATE # >>>");
        KllMiscDoublesTest.println(sk.toString(false, true));
        KllMiscDoublesTest.println("");
    }

    @Test
    public void viewCompactionAndSortedView() {
        int n = 43;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 43; ++i) {
            sk.update((double)i);
        }
        KllMiscDoublesTest.println(sk.toString(true, true));
        DoublesSketchSortedView sv = sk.getSortedView();
        DoublesSortedViewIterator itr = sv.iterator();
        KllMiscDoublesTest.println("### SORTED VIEW");
        KllMiscDoublesTest.printf("%6s %12s %12s" + Util.LS, "Idx", "Value", "CumWeight");
        int i = 0;
        while (itr.next()) {
            double v = itr.getQuantile();
            long wt = itr.getWeight();
            KllMiscDoublesTest.printf("%6d %12.1f %12d" + Util.LS, i, v, wt);
            ++i;
        }
        Assert.assertEquals((double)sv.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sv.getMaxItem(), (double)43.0);
    }

    @Test
    public void checkWeightedUpdates1() {
        int k = 20;
        int weight = 127;
        double item = 10.0;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        KllMiscDoublesTest.println(sk.toString(true, true));
        sk.update(10.0, 127L);
        KllMiscDoublesTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumRetained(), (int)7);
        Assert.assertEquals((long)sk.getN(), (long)127L);
        sk.update(10.0, 127L);
        KllMiscDoublesTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumRetained(), (int)14);
        Assert.assertEquals((long)sk.getN(), (long)254L);
    }

    @Test
    public void checkWeightedUpdates2() {
        int k = 20;
        int initial = 1000;
        int weight = 127;
        double item = 10.0;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 1000; ++i) {
            sk.update((double)(i + 1000));
        }
        KllMiscDoublesTest.println(sk.toString(true, true));
        sk.update(10.0, 127L);
        KllMiscDoublesTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumRetained(), (int)65);
        Assert.assertEquals((long)sk.getN(), (long)1127L);
        DoublesSortedViewIterator itr = sk.getSortedView().iterator();
        KllMiscDoublesTest.println("### SORTED VIEW");
        KllMiscDoublesTest.printf("%12s %12s %12s" + Util.LS, "Value", "Weight", "NaturalRank");
        long cumWt = 0L;
        while (itr.next()) {
            double v = itr.getQuantile();
            long wt = itr.getWeight();
            long natRank = itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE);
            Assert.assertEquals((long)(cumWt += wt), (long)natRank);
            KllMiscDoublesTest.printf("%12.1f %12d %12d" + Util.LS, v, wt, natRank);
        }
        Assert.assertEquals((long)cumWt, (long)sk.getN());
    }

    @Test
    public void checkCreateItemsArray() {
        double item = 10.0;
        int weight = 108;
        double[] itemsArr = KllDoublesHelper.createItemsArray((double)10.0, (long)108L);
        Assert.assertEquals((int)itemsArr.length, (int)4);
        Arrays.fill(itemsArr, 10.0);
        KllMiscDoublesTest.outputItems(itemsArr);
    }

    private static void outputItems(double[] itemsArr) {
        String[] hdr2 = new String[]{"Index", "Value"};
        String hdr2fmt = "%6s %15s" + Util.LS;
        String d2fmt = "%6d %15f" + Util.LS;
        KllMiscDoublesTest.println("ItemsArr");
        KllMiscDoublesTest.printf(hdr2fmt, hdr2);
        for (int i = 0; i < itemsArr.length; ++i) {
            KllMiscDoublesTest.printf(d2fmt, i, itemsArr[i]);
        }
        KllMiscDoublesTest.println("");
    }

    @Test
    public void checkCreateLevelsArray() {
        int weight = 108;
        int[] levelsArr = KllHelper.createLevelsArray((long)108L);
        Assert.assertEquals((int)levelsArr.length, (int)8);
        int[] correct = new int[]{0, 0, 0, 1, 2, 2, 3, 4};
        for (int i = 0; i < levelsArr.length; ++i) {
            Assert.assertEquals((int)levelsArr[i], (int)correct[i]);
        }
        KllMiscDoublesTest.outputLevels(108, levelsArr);
    }

    private static void outputLevels(int weight, int[] levelsArr) {
        String[] hdr = new String[]{"Lvl", "StartAdr", "BitPattern", "Weight"};
        String hdrfmt = "%3s %9s %10s %s" + Util.LS;
        String dfmt = "%3d %9d %10d %d" + Util.LS;
        String dfmt_2 = "%3d %9d %s" + Util.LS;
        KllMiscDoublesTest.println("Count = " + weight + " => " + Integer.toBinaryString(weight));
        KllMiscDoublesTest.println("LevelsArr");
        KllMiscDoublesTest.printf(hdrfmt, hdr);
        for (int i = 0; i < levelsArr.length; ++i) {
            if (i == levelsArr.length - 1) {
                KllMiscDoublesTest.printf(dfmt_2, i, levelsArr[i], "ItemsArr.length");
                continue;
            }
            int j = Util.bitAt((long)weight, (int)i);
            KllMiscDoublesTest.printf(dfmt, i, levelsArr[i], j, 1 << i);
        }
        KllMiscDoublesTest.println("");
    }

    @Test
    public void viewMemorySketchData() {
        int k = 20;
        int n = 109;
        boolean withLevels = true;
        boolean withLevelsAndItems = true;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 109; ++i) {
            sk.update((double)i);
        }
        byte[] byteArr = sk.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        KllDoublesSketch ddSk = KllDoublesSketch.wrap((MemorySegment)seg);
        KllMiscDoublesTest.println(ddSk.toString(true, true));
        Assert.assertEquals((long)ddSk.getN(), (long)109L);
    }

    @Test
    public void checkIntCapAux() {
        String[] hdr = new String[]{"level", "depth", "wt", "cap", "(end)", "MaxN"};
        String hdrFmt = "%6s %6s %28s %10s %10s %34s" + Util.LS;
        String dataFmt = "%6d %6d %,28d %,10d %,10d %,34.0f" + Util.LS;
        int k = 1000;
        int m = 8;
        int numLevels = 20;
        KllMiscDoublesTest.println("k=1000, m=8, numLevels=20");
        KllMiscDoublesTest.printf(hdrFmt, hdr);
        double maxN = 0.0;
        double[] correct = new double[]{0.0, 1.0, 1.0, 2.0, 2.0, 3.0, 5.0, 8.0, 12.0, 17.0, 26.0, 39.0, 59.0, 88.0, 132.0, 198.0, 296.0, 444.0, 667.0, 1000.0};
        for (int i = 0; i < 20; ++i) {
            int depth = 20 - i - 1;
            long cap = KllHelper.intCapAux((int)1000, (int)depth);
            long end = Math.max(8L, cap);
            long wt = 1L << i;
            KllMiscDoublesTest.printf(dataFmt, i, depth, wt, cap, end, maxN += (double)wt * (double)end);
            Assert.assertEquals((double)cap, (double)correct[i]);
        }
    }

    @Test
    public void checkIntCapAuxAux() {
        String[] hdr = new String[]{"d", "twoK", "2k*2^d", "3^d", "tmp=2k*2^d/3^d", "(tmp + 1)/2", "(end)"};
        String hdrFmt = "%6s %10s %20s %20s %15s %12s %10s" + Util.LS;
        String dataFmt = "%6d %10d %,20d %,20d %15d %12d %10d" + Util.LS;
        long k = 65535L;
        long m = 8L;
        KllMiscDoublesTest.println("k = 65535, m = 8");
        KllMiscDoublesTest.printf(hdrFmt, hdr);
        long[] correct = new long[]{65535L, 43690L, 29127L, 19418L, 12945L, 8630L, 5753L, 3836L, 2557L, 1705L, 1136L, 758L, 505L, 337L, 224L, 150L, 100L, 67L, 44L, 30L, 20L, 13L, 9L, 6L, 4L, 3L, 2L, 1L, 1L, 1L, 0L};
        for (int i = 0; i < 31; ++i) {
            long twoK = 131070L;
            long twoKxtwoD = 131070L << i;
            long threeToD = KllHelper.powersOfThree[i];
            long tmp = twoKxtwoD / threeToD;
            long result = tmp + 1L >>> 1;
            long end = Math.max(8L, result);
            KllMiscDoublesTest.printf(dataFmt, i, 131070L, twoKxtwoD, threeToD, tmp, result, end);
            Assert.assertEquals((long)result, (long)correct[i]);
            Assert.assertEquals((long)result, (long)KllHelper.intCapAuxAux((long)65535L, (int)i));
        }
    }

    @Test
    public void checkGrowLevels() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure)[2], (int)33);
    }

    @Test
    public void checkSketchInitializeDoubleHeap() {
        int k = 20;
        KllMiscDoublesTest.println("#### CASE: DOUBLE FULL HEAP");
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        KllMiscDoublesTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)21L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscDoublesTest.println("#### CASE: DOUBLE HEAP EMPTY");
        sk = KllDoublesSketch.newHeapInstance((int)20);
        KllMiscDoublesTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscDoublesTest.println("#### CASE: DOUBLE HEAP SINGLE");
        sk = KllDoublesSketch.newHeapInstance((int)20);
        sk.update(1.0);
        KllMiscDoublesTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeDoubleHeapifyCompactMemorySegment() {
        int k = 20;
        KllMiscDoublesTest.println("#### CASE: DOUBLE FULL HEAPIFIED FROM COMPACT");
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((double)i);
        }
        byte[] compBytes = sk2.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(compBytes);
        KllMiscDoublesTest.println(KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true));
        KllDoublesSketch sk = KllDoublesSketch.heapify((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)21L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscDoublesTest.println("#### CASE: DOUBLE EMPTY HEAPIFIED FROM COMPACT");
        sk2 = KllDoublesSketch.newHeapInstance((int)20);
        compBytes = sk2.toByteArray();
        wseg = MemorySegment.ofArray(compBytes);
        sk = KllDoublesSketch.heapify((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscDoublesTest.println("#### CASE: DOUBLE SINGLE HEAPIFIED FROM COMPACT");
        sk2 = KllDoublesSketch.newHeapInstance((int)20);
        sk2.update(1.0);
        compBytes = sk2.toByteArray();
        wseg = MemorySegment.ofArray(compBytes);
        sk = KllDoublesSketch.heapify((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeDoubleHeapifyUpdatableMemorySegment() {
        int k = 20;
        KllMiscDoublesTest.println("#### CASE: DOUBLE FULL HEAPIFIED FROM UPDATABLE");
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((double)i);
        }
        byte[] compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        MemorySegment wseg = MemorySegment.ofArray(compBytes);
        KllMiscDoublesTest.println(KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true));
        KllHeapDoublesSketch sk = KllHeapDoublesSketch.heapifyImpl((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)21L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscDoublesTest.println("#### CASE: DOUBLE EMPTY HEAPIFIED FROM UPDATABLE");
        sk2 = KllDoublesSketch.newHeapInstance((int)20);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(compBytes);
        sk = KllHeapDoublesSketch.heapifyImpl((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscDoublesTest.println("#### CASE: DOUBLE SINGLE HEAPIFIED FROM UPDATABLE");
        sk2 = KllDoublesSketch.newHeapInstance((int)20);
        sk2.update(1.0);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(compBytes);
        sk = KllHeapDoublesSketch.heapifyImpl((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkMemoryToStringDoubleCompact() {
        int k = 20;
        KllMiscDoublesTest.println("#### CASE: DOUBLE FULL COMPACT");
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        byte[] compBytes = sk.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(compBytes);
        String s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 1: sketch to byte[]/segory & analyze segory");
        KllMiscDoublesTest.println(s);
        KllDoublesSketch sk2 = KllDoublesSketch.heapify((MemorySegment)wseg);
        byte[] compBytes2 = sk2.toByteArray();
        wseg = MemorySegment.ofArray(compBytes2);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 2: segorySegment to heap sketch, to byte[]/MemorySegment & analyze MemorySegment. Should match above");
        KllMiscDoublesTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscDoublesTest.println("#### CASE: DOUBLE EMPTY COMPACT");
        sk = KllDoublesSketch.newHeapInstance((int)20);
        compBytes = sk.toByteArray();
        wseg = MemorySegment.ofArray(compBytes);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 1: sketch to byte[]/MemorySegment & analyze MemorySegment");
        KllMiscDoublesTest.println(s);
        sk2 = KllDoublesSketch.heapify((MemorySegment)wseg);
        compBytes2 = sk2.toByteArray();
        wseg = MemorySegment.ofArray(compBytes2);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 2: MemorySegment to heap sketch, to byte[]/MemorySegment & analyze MemorySegment. Should match above");
        KllMiscDoublesTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscDoublesTest.println("#### CASE: DOUBLE SINGLE COMPACT");
        sk = KllDoublesSketch.newHeapInstance((int)20);
        sk.update(1.0);
        compBytes = sk.toByteArray();
        wseg = MemorySegment.ofArray(compBytes);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 1: sketch to byte[]/MemorySegment & analyze MemorySegment");
        KllMiscDoublesTest.println(s);
        sk2 = KllDoublesSketch.heapify((MemorySegment)wseg);
        compBytes2 = sk2.toByteArray();
        wseg = MemorySegment.ofArray(compBytes2);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 2: MemorySegment to heap sketch, to byte[]/MemorySegment & analyze MemorySegment. Should match above");
        KllMiscDoublesTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
    }

    @Test
    public void checkMemoryToStringDoubleUpdatable() {
        int k = 20;
        KllMiscDoublesTest.println("#### CASE: DOUBLE FULL UPDATABLE");
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        byte[] upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        MemorySegment wseg = MemorySegment.ofArray(upBytes);
        String s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 1: sketch to byte[]/MemorySegment & analyze MemorySegment");
        KllMiscDoublesTest.println(s);
        KllHeapDoublesSketch sk2 = KllHeapDoublesSketch.heapifyImpl((MemorySegment)wseg);
        byte[] upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(upBytes2);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 2: MemorySegment to heap sketch, to byte[]/MemorySegment & analyze MemorySegment. Should match above");
        KllMiscDoublesTest.println(s);
        Assert.assertEquals((long)sk.getN(), (long)sk2.getN());
        Assert.assertEquals((double)sk.getMinItem(), (double)sk2.getMinItem());
        Assert.assertEquals((double)sk.getMaxItem(), (double)sk2.getMaxItem());
        Assert.assertEquals((int)sk.getNumRetained(), (int)sk2.getNumRetained());
        KllMiscDoublesTest.println("#### CASE: DOUBLE EMPTY UPDATABLE");
        sk = KllDoublesSketch.newHeapInstance((int)20);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wseg = MemorySegment.ofArray(upBytes);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 1: sketch to byte[]/MemorySegment & analyze MemorySegment");
        KllMiscDoublesTest.println(s);
        sk2 = KllHeapDoublesSketch.heapifyImpl((MemorySegment)wseg);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(upBytes2);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 2: MemorySegment to heap sketch, to byte[]/MemorySegment & analyze MemorySegment. Should match above");
        KllMiscDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        KllMiscDoublesTest.println("#### CASE: DOUBLE SINGLE UPDATABL");
        sk = KllDoublesSketch.newHeapInstance((int)20);
        sk.update(1.0);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wseg = MemorySegment.ofArray(upBytes);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 1: sketch to byte[]/MemorySegment & analyze MemorySegment");
        KllMiscDoublesTest.println(s);
        sk2 = KllHeapDoublesSketch.heapifyImpl((MemorySegment)wseg);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(upBytes2);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 2: MemorySegment to heap sketch, to byte[]/MemorySegment & analyze MemorySegment. Should match above");
        KllMiscDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
    }

    @Test
    public void checkSimpleMerge() {
        int i;
        int k = 20;
        int m = 8;
        int n1 = 21;
        int n2 = 43;
        MemorySegment wseg = MemorySegment.ofArray(new byte[3000]);
        MemorySegment wseg2 = MemorySegment.ofArray(new byte[3000]);
        KllDirectDoublesSketch sk1 = KllDirectDoublesSketch.newDirectUpdatableInstance((int)20, (int)8, (MemorySegment)wseg, null);
        KllDirectDoublesSketch sk2 = KllDirectDoublesSketch.newDirectUpdatableInstance((int)20, (int)8, (MemorySegment)wseg2, null);
        for (i = 1; i <= 21; ++i) {
            sk1.update((double)i);
        }
        for (i = 1; i <= 43; ++i) {
            sk2.update((double)(i + 100));
        }
        sk1.merge((KllSketch)sk2);
        Assert.assertEquals((double)sk1.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk1.getMaxItem(), (double)143.0);
    }

    @Test
    public void checkGetSingleItem() {
        int k = 20;
        KllDoublesSketch skHeap = KllDoublesSketch.newHeapInstance((int)20);
        skHeap.update(1.0);
        Assert.assertTrue((boolean)(skHeap instanceof KllHeapDoublesSketch));
        Assert.assertEquals((double)skHeap.getDoubleSingleItem(), (double)1.0);
        MemorySegment srcSeg = MemorySegment.ofArray(KllHelper.toByteArray((KllSketch)skHeap, (boolean)true));
        KllDoublesSketch skDirect = KllDoublesSketch.wrap((MemorySegment)srcSeg);
        Assert.assertTrue((boolean)(skDirect instanceof KllDirectDoublesSketch));
        Assert.assertEquals((double)skDirect.getDoubleSingleItem(), (double)1.0);
        MemorySegment srcSeg2 = MemorySegment.ofArray(skHeap.toByteArray());
        KllDoublesSketch skCompact = KllDoublesSketch.wrap((MemorySegment)srcSeg2);
        Assert.assertEquals((double)skCompact.getDoubleSingleItem(), (double)1.0);
    }

    @Test
    public void printlnTest() {
        String s = "PRINTING:  printf in " + this.getClass().getName();
        KllMiscDoublesTest.println(s);
        KllMiscDoublesTest.printf("%s" + Util.LS, s);
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

