/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.felix.webconsole.spi.BrandingPlugin;

public class BrandingPluginImpl
implements BrandingPlugin {
    private static final String BRANDING_PROPERTIES = "/META-INF/webconsole.properties";
    private final String brandName;
    private final String productName;
    private final String productURL;
    private final String productImage;
    private final String vendorName;
    private final String vendorURL;
    private final String vendorImage;
    private final String favIcon;
    private final String mainStyleSheet;

    public BrandingPluginImpl() {
        Properties props = new Properties();
        try (InputStream ins = this.getClass().getResourceAsStream(BRANDING_PROPERTIES);){
            if (ins != null) {
                props.load(ins);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.brandName = props.getProperty("webconsole.brand.name", "Apache Felix Web Console");
        this.productName = props.getProperty("webconsole.product.name", "Apache Felix");
        this.productURL = props.getProperty("webconsole.product.url", "https://felix.apache.org");
        this.productImage = props.getProperty("webconsole.product.image", "/res/imgs/logo.png");
        this.vendorName = props.getProperty("webconsole.vendor.name", "The Apache Software Foundation");
        this.vendorURL = props.getProperty("webconsole.vendor.url", "https://www.apache.org");
        this.vendorImage = props.getProperty("webconsole.vendor.image", "/res/imgs/logo.png");
        this.favIcon = props.getProperty("webconsole.favicon", "/res/imgs/favicon.ico");
        this.mainStyleSheet = props.getProperty("webconsole.stylesheet", "/res/ui/webconsole.css");
    }

    @Override
    public String getBrandName() {
        return this.brandName;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getProductURL() {
        return this.productURL;
    }

    @Override
    public String getProductImage() {
        return this.productImage;
    }

    @Override
    public String getVendorName() {
        return this.vendorName;
    }

    @Override
    public String getVendorURL() {
        return this.vendorURL;
    }

    @Override
    public String getVendorImage() {
        return this.vendorImage;
    }

    @Override
    public String getFavIcon() {
        return this.favIcon;
    }

    @Override
    public String getMainStyleSheet() {
        return this.mainStyleSheet;
    }
}

