/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.io.Serializable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.typeinfo.NothingTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.legacy.types.logical.TypeInformationRawType;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.plan.schema.GenericRelDataType;
import org.apache.flink.table.planner.plan.schema.RawRelDataType;
import org.apache.flink.table.planner.plan.schema.StructuredRelDataType;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.SymbolType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;

public final class FlinkTypeFactory$ {
    public static FlinkTypeFactory$ MODULE$;

    static {
        new FlinkTypeFactory$();
    }

    public RelDataTypeSystem $lessinit$greater$default$2() {
        return FlinkTypeSystem.INSTANCE;
    }

    public boolean isTimeIndicatorType(LogicalType t) {
        LogicalType logicalType = t;
        if (logicalType instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)logicalType;
            TimestampKind timestampKind = timestampType.getKind();
            TimestampKind timestampKind2 = TimestampKind.ROWTIME;
            if (!(timestampKind != null ? !timestampKind.equals(timestampKind2) : timestampKind2 != null)) {
                return true;
            }
        }
        if (logicalType instanceof LocalZonedTimestampType) {
            LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)logicalType;
            TimestampKind timestampKind = localZonedTimestampType.getKind();
            TimestampKind timestampKind3 = TimestampKind.PROCTIME;
            if (!(timestampKind != null ? !timestampKind.equals(timestampKind3) : timestampKind3 != null)) {
                return true;
            }
        }
        return false;
    }

    public boolean isTimeIndicatorType(RelDataType relDataType) {
        RelDataType relDataType2 = relDataType;
        return relDataType2 instanceof TimeIndicatorRelDataType;
    }

    public boolean isRowtimeIndicatorType(RelDataType relDataType) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType2 = relDataType;
        return relDataType2 instanceof TimeIndicatorRelDataType && (timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType2).isEventTime();
    }

    public boolean isProctimeIndicatorType(RelDataType relDataType) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType2 = relDataType;
        return relDataType2 instanceof TimeIndicatorRelDataType && !(timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType2).isEventTime();
    }

    public boolean isTimestampLtzIndicatorType(RelDataType relDataType) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType2 = relDataType;
        return relDataType2 instanceof TimeIndicatorRelDataType && (timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType2).originalType().getSqlTypeName().equals((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
    }

    @Deprecated
    public boolean isProctimeIndicatorType(TypeInformation<?> typeInfo) {
        TimeIndicatorTypeInfo timeIndicatorTypeInfo;
        TypeInformation<?> typeInformation = typeInfo;
        return typeInformation instanceof TimeIndicatorTypeInfo && !(timeIndicatorTypeInfo = (TimeIndicatorTypeInfo)typeInformation).isEventTime();
    }

    @Deprecated
    public boolean isRowtimeIndicatorType(TypeInformation<?> typeInfo) {
        TimeIndicatorTypeInfo timeIndicatorTypeInfo;
        TypeInformation<?> typeInformation = typeInfo;
        return typeInformation instanceof TimeIndicatorTypeInfo && (timeIndicatorTypeInfo = (TimeIndicatorTypeInfo)typeInformation).isEventTime();
    }

    @Deprecated
    public boolean isTimeIndicatorType(TypeInformation<?> typeInfo) {
        TypeInformation<?> typeInformation = typeInfo;
        return typeInformation instanceof TimeIndicatorTypeInfo;
    }

    /*
     * Unable to fully structure code
     */
    public LogicalType toLogicalType(RelDataType relDataType) {
        block37: {
            block49: {
                block50: {
                    block48: {
                        block47: {
                            block46: {
                                block45: {
                                    block44: {
                                        block43: {
                                            block42: {
                                                block41: {
                                                    block40: {
                                                        block39: {
                                                            block38: {
                                                                block36: {
                                                                    var4_2 = false;
                                                                    var5_3 = null;
                                                                    var6_4 = false;
                                                                    var7_5 = null;
                                                                    var8_6 = relDataType.getSqlTypeName();
                                                                    if (!SqlTypeName.BOOLEAN.equals((Object)var8_6)) break block36;
                                                                    v0 = new LocalZonedTimestampType();
                                                                    break block37;
                                                                }
                                                                if (!SqlTypeName.TINYINT.equals((Object)var8_6)) break block38;
                                                                v0 = new TinyIntType();
                                                                break block37;
                                                            }
                                                            if (!SqlTypeName.SMALLINT.equals((Object)var8_6)) break block39;
                                                            v0 = new SmallIntType();
                                                            break block37;
                                                        }
                                                        if (!SqlTypeName.INTEGER.equals((Object)var8_6)) break block40;
                                                        v0 = new IntType();
                                                        break block37;
                                                    }
                                                    if (!SqlTypeName.BIGINT.equals((Object)var8_6)) break block41;
                                                    v0 = new BigIntType();
                                                    break block37;
                                                }
                                                if (!SqlTypeName.FLOAT.equals((Object)var8_6)) break block42;
                                                v0 = new FloatType();
                                                break block37;
                                            }
                                            if (!SqlTypeName.DOUBLE.equals((Object)var8_6)) break block43;
                                            v0 = new DoubleType();
                                            break block37;
                                        }
                                        if (!SqlTypeName.CHAR.equals((Object)var8_6)) break block44;
                                        v0 = relDataType.getPrecision() == 0 ? CharType.ofEmptyLiteral() : new CharType(relDataType.getPrecision());
                                        break block37;
                                    }
                                    if (!SqlTypeName.VARCHAR.equals((Object)var8_6)) break block45;
                                    v0 = relDataType.getPrecision() == 0 ? VarCharType.ofEmptyLiteral() : new VarCharType(relDataType.getPrecision());
                                    break block37;
                                }
                                if (!SqlTypeName.BINARY.equals((Object)var8_6)) break block46;
                                v0 = relDataType.getPrecision() == 0 ? BinaryType.ofEmptyLiteral() : new BinaryType(relDataType.getPrecision());
                                break block37;
                            }
                            if (!SqlTypeName.VARBINARY.equals((Object)var8_6)) break block47;
                            v0 = relDataType.getPrecision() == 0 ? VarBinaryType.ofEmptyLiteral() : new VarBinaryType(relDataType.getPrecision());
                            break block37;
                        }
                        if (!SqlTypeName.DECIMAL.equals((Object)var8_6)) break block48;
                        v0 = new DecimalType(relDataType.getPrecision(), relDataType.getScale());
                        break block37;
                    }
                    if (!SqlTypeName.TIMESTAMP.equals((Object)var8_6)) break block49;
                    var4_2 = true;
                    var5_3 = var8_6;
                    if (!(relDataType instanceof TimeIndicatorRelDataType)) break block49;
                    indicator = (TimeIndicatorRelDataType)relDataType;
                    if (!indicator.isEventTime()) break block50;
                    v0 = new TimestampType(true, TimestampKind.ROWTIME, 3);
                    break block37;
                }
                throw new TableException(new StringBuilder(141).append("Processing time indicator only supports").append(" LocalZonedTimestampType, but actual is TimestampType.").append(" This is a bug in planner, please file an issue.").toString());
            }
            if (!SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var8_6)) ** GOTO lbl-1000
            var6_4 = true;
            var7_5 = var8_6;
            if (relDataType instanceof TimeIndicatorRelDataType) {
                indicator = (TimeIndicatorRelDataType)relDataType;
                v0 = indicator.isEventTime() ? new LocalZonedTimestampType(true, TimestampKind.ROWTIME, 3) : new LocalZonedTimestampType(true, TimestampKind.PROCTIME, 3);
            } else if (SqlTypeName.DATE.equals((Object)var8_6)) {
                v0 = new DateType();
            } else if (SqlTypeName.TIME.equals((Object)var8_6)) {
                if (relDataType.getPrecision() > 3) {
                    throw new TableException(new StringBuilder(33).append("TIME precision is not supported: ").append(relDataType.getPrecision()).toString());
                }
                v0 = new TimeType();
            } else if (var4_2) {
                v0 = new TimestampType(relDataType.getPrecision());
            } else if (var6_4) {
                v0 = new LocalZonedTimestampType(relDataType.getPrecision());
            } else if (SqlTypeName.YEAR_INTERVAL_TYPES.contains((Object)var8_6)) {
                v0 = DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).getLogicalType();
            } else if (SqlTypeName.DAY_INTERVAL_TYPES.contains((Object)var8_6)) {
                if (relDataType.getPrecision() > 3) {
                    throw new TableException(new StringBuilder(47).append("DAY_INTERVAL_TYPES precision is not supported: ").append(relDataType.getPrecision()).toString());
                }
                v0 = DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3)).getLogicalType();
            } else if (SqlTypeName.NULL.equals((Object)var8_6)) {
                v0 = new NullType();
            } else if (SqlTypeName.SYMBOL.equals((Object)var8_6)) {
                v0 = new SymbolType();
            } else if (SqlTypeName.ANY.equals((Object)var8_6) && relDataType instanceof GenericRelDataType) {
                genericRelDataType = (GenericRelDataType)relDataType;
                v0 = genericRelDataType.genericType();
            } else if (SqlTypeName.ROW.equals((Object)var8_6) && relDataType instanceof RelRecordType) {
                v0 = this.toLogicalRowType(relDataType);
            } else if (SqlTypeName.STRUCTURED.equals((Object)var8_6) && relDataType instanceof StructuredRelDataType) {
                v0 = ((StructuredRelDataType)relDataType).getStructuredType();
            } else if (SqlTypeName.MULTISET.equals((Object)var8_6)) {
                v0 = new MultisetType(this.toLogicalType(relDataType.getComponentType()));
            } else if (SqlTypeName.ARRAY.equals((Object)var8_6)) {
                v0 = new ArrayType(this.toLogicalType(relDataType.getComponentType()));
            } else if (SqlTypeName.MAP.equals((Object)var8_6) && relDataType instanceof MapSqlType) {
                mapRelDataType = (MapSqlType)relDataType;
                v0 = new MapType(this.toLogicalType(mapRelDataType.getKeyType()), this.toLogicalType(mapRelDataType.getValueType()));
            } else if (SqlTypeName.CURSOR.equals((Object)var8_6)) {
                v0 = new TypeInformationRawType((TypeInformation)new NothingTypeInfo());
            } else if (SqlTypeName.OTHER.equals((Object)var8_6) && relDataType instanceof RawRelDataType) {
                v0 = ((RawRelDataType)relDataType).getRawType();
            } else {
                throw new TableException(new StringBuilder(23).append("Type is not supported: ").append((Object)var8_6).toString());
            }
        }
        logicalType = v0;
        return logicalType.copy(relDataType.isNullable());
    }

    public TableSchema toTableSchema(RelDataType relDataType) {
        String[] fieldNames = (String[])relDataType.getFieldNames().toArray((Object[])new String[0]);
        DataType[] fieldTypes = (DataType[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(relDataType.getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)MODULE$.toLogicalType(field.getType())), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
        return TableSchema.builder().fields(fieldNames, fieldTypes).build();
    }

    public RowType toLogicalRowType(RelDataType relType) {
        Preconditions.checkArgument((boolean)relType.isStruct());
        return RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(relType.getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)fieldType -> MODULE$.toLogicalType(fieldType.getType()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalType.class))), (String[])((String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(relType.getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    private FlinkTypeFactory$() {
        MODULE$ = this;
    }
}

