/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.common;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.logical.CumulativeWindowSpec;
import org.apache.flink.table.planner.plan.logical.HoppingWindowSpec;
import org.apache.flink.table.planner.plan.logical.SessionWindowSpec;
import org.apache.flink.table.planner.plan.logical.TimeAttributeWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.TumblingWindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194Qa\u0003\u0007\u0002\u0002uA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011!Y\u0004A!b\u0001\n\u0003a\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b\u0011\u0003A\u0011A#\t\u000b5\u0003A\u0011\t(\t\u000b=\u0003A\u0011\t)\t\u000bY\u0003A\u0011I,\u0003C\r{W.\\8o!\"L8/[2bY^Kg\u000eZ8x)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8\u000b\u00055q\u0011AB2p[6|gN\u0003\u0002\u0010!\u0005)an\u001c3fg*\u0011\u0011CE\u0001\u0005a2\fgN\u0003\u0002\u0014)\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u000b\u0017\u0003\u0015!\u0018M\u00197f\u0015\t9\u0002$A\u0003gY&t7N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0003\u0001y\u0001\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\u0007I,GN\u0003\u0002$1\u000591-\u00197dSR,\u0017BA\u0013!\u0005%\u0019\u0016N\\4mKJ+G.A\u0004dYV\u001cH/\u001a:\u0011\u0005!RS\"A\u0015\u000b\u0005E\u0011\u0013BA\u0016*\u00055\u0011V\r\\(qi\u000ecWo\u001d;fe\u0006AAO]1jiN+G\u000f\u0005\u0002)]%\u0011q&\u000b\u0002\f%\u0016dGK]1jiN+G/\u0001\u0005j]B,HOU3m!\ty\"'\u0003\u00024A\t9!+\u001a7O_\u0012,\u0017!D8viB,HOU8x)f\u0004X\r\u0005\u00027s5\tqG\u0003\u00029A\u0005!A/\u001f9f\u0013\tQtGA\u0006SK2$\u0015\r^1UsB,\u0017!C<j]\u0012|w/\u001b8h+\u0005i\u0004C\u0001 B\u001b\u0005y$B\u0001!\u0011\u0003\u001dawnZ5dC2L!AQ \u0003=QKW.Z!uiJL'-\u001e;f/&tGm\\<j]\u001e\u001cFO]1uK\u001eL\u0018AC<j]\u0012|w/\u001b8hA\u00051A(\u001b8jiz\"bA\u0012%J\u0015.c\u0005CA$\u0001\u001b\u0005a\u0001\"\u0002\u0014\b\u0001\u00049\u0003\"\u0002\u0017\b\u0001\u0004i\u0003\"\u0002\u0019\b\u0001\u0004\t\u0004\"\u0002\u001b\b\u0001\u0004)\u0004\"B\u001e\b\u0001\u0004i\u0014!\u00043fe&4XMU8x)f\u0004X\rF\u00016\u00031)\u0007\u0010\u001d7bS:$VM]7t)\t\tF\u000b\u0005\u0002 %&\u00111\u000b\t\u0002\n%\u0016dwK]5uKJDQ!V\u0005A\u0002E\u000b!\u0001]<\u0002!\u0015\u001cH/[7bi\u0016\u0014vn^\"pk:$HC\u0001-_!\tIF,D\u0001[\u0015\u0005Y\u0016!B:dC2\f\u0017BA/[\u0005\u0019!u.\u001e2mK\")qL\u0003a\u0001A\u0006\u0011Q.\u001d\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u0002\n\u0001\"\\3uC\u0012\fG/Y\u0005\u0003K\n\u0014\u0001CU3m\u001b\u0016$\u0018\rZ1uCF+XM]=")
public abstract class CommonPhysicalWindowTableFunction
extends SingleRel {
    private final RelDataType outputRowType;
    private final TimeAttributeWindowingStrategy windowing;

    public TimeAttributeWindowingStrategy windowing() {
        return this.windowing;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.outputRowType;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        String[] inputFieldNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.getInput().getRowType().getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        return super.explainTerms(pw).item("window", this.windowing().toSummaryString(inputFieldNames));
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        Double childRowCnt = mq.getRowCount(this.getInput());
        if (childRowCnt != null) {
            WindowSpec windowSpec = this.windowing().getWindow();
            if (windowSpec instanceof TumblingWindowSpec) {
                return Predef$.MODULE$.Double2double(childRowCnt);
            }
            if (windowSpec instanceof HoppingWindowSpec) {
                HoppingWindowSpec hoppingWindowSpec = (HoppingWindowSpec)windowSpec;
                int windowsNum = (int)(hoppingWindowSpec.getSize().toMillis() / hoppingWindowSpec.getSlide().toMillis());
                return Predef$.MODULE$.Double2double(childRowCnt) * (double)windowsNum;
            }
            if (windowSpec instanceof CumulativeWindowSpec) {
                CumulativeWindowSpec cumulativeWindowSpec = (CumulativeWindowSpec)windowSpec;
                int maxWindowsNum = (int)(cumulativeWindowSpec.getMaxSize().toMillis() / cumulativeWindowSpec.getStep().toMillis());
                return Predef$.MODULE$.Double2double(childRowCnt) * (double)maxWindowsNum;
            }
            if (windowSpec instanceof SessionWindowSpec) {
                SessionWindowSpec sessionWindowSpec = (SessionWindowSpec)windowSpec;
                return Predef$.MODULE$.Double2double(childRowCnt) * (double)((int)sessionWindowSpec.getGap().toMillis());
            }
            throw new TableException(new StringBuilder(21).append("Unknown window spec: ").append(windowSpec.getClass().getSimpleName()).toString());
        }
        return BoxesRunTime.unboxToDouble(null);
    }

    public CommonPhysicalWindowTableFunction(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputRel, RelDataType outputRowType, TimeAttributeWindowingStrategy windowing) {
        this.outputRowType = outputRowType;
        this.windowing = windowing;
        super(cluster, traitSet, inputRel);
    }
}

