/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.utils.NestedColumn;
import org.apache.flink.table.planner.plan.utils.NestedSchema;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A\u0001C\u0005\u00051!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015Q\u0003\u0001\"\u0001,\u0011\u0015y\u0003\u0001\"\u00111\u0011\u0015I\u0004\u0001\"\u0011;\u0011\u0015\u0001\u0005\u0001\"\u0003B\u0011\u0015y\u0005\u0001\"\u0003Q\u0005QqUm\u001d;fIN\u001b\u0007.Z7b%\u0016<(/\u001b;fe*\u0011!bC\u0001\u0006kRLGn\u001d\u0006\u0003\u00195\tA\u0001\u001d7b]*\u0011abD\u0001\ba2\fgN\\3s\u0015\t\u0001\u0012#A\u0003uC\ndWM\u0003\u0002\u0013'\u0005)a\r\\5oW*\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iyR\"A\u000e\u000b\u0005qi\u0012a\u0001:fq*\u0011adE\u0001\bG\u0006d7-\u001b;f\u0013\t\u00013D\u0001\u0006SKb\u001c\u0006.\u001e;uY\u0016\faa]2iK6\f\u0007CA\u0012%\u001b\u0005I\u0011BA\u0013\n\u00051qUm\u001d;fIN\u001b\u0007.Z7b\u0003\u001d\u0011W/\u001b7eKJ\u0004\"A\u0007\u0015\n\u0005%Z\"A\u0003*fq\n+\u0018\u000e\u001c3fe\u00061A(\u001b8jiz\"2\u0001L\u0017/!\t\u0019\u0003\u0001C\u0003\"\u0007\u0001\u0007!\u0005C\u0003'\u0007\u0001\u0007q%A\u0007wSNLG/\u00138qkR\u0014VM\u001a\u000b\u0003cQ\u0002\"A\u0007\u001a\n\u0005MZ\"a\u0002*fq:{G-\u001a\u0005\u0006k\u0011\u0001\rAN\u0001\tS:\u0004X\u000f\u001e*fMB\u0011!dN\u0005\u0003qm\u00111BU3y\u0013:\u0004X\u000f\u001e*fM\u0006\u0001b/[:ji\u001aKW\r\u001c3BG\u000e,7o\u001d\u000b\u0003cmBQ\u0001P\u0003A\u0002u\n1BZ5fY\u0012\f5mY3tgB\u0011!DP\u0005\u0003\u007fm\u0011aBU3y\r&,G\u000eZ!dG\u0016\u001c8/\u0001\u0005ue\u00064XM]:f)\t\u0011e\n\u0005\u0003D\r\"[U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\rQ+\b\u000f\\33!\r\u0019\u0015*M\u0005\u0003\u0015\u0012\u0013aa\u00149uS>t\u0007CA\u0012M\u0013\ti\u0015B\u0001\u0007OKN$X\rZ\"pYVlg\u000eC\u0003=\r\u0001\u0007Q(A\bd_BLh)[3mI\u0006\u001b7-Z:t)\u0011\t\u0014k\u00151\t\u000bI;\u0001\u0019A\u0019\u0002\u000f9,w/\u0012=qe\")Ak\u0002a\u0001+\u0006Ia-[3mI:\u000bW.\u001a\t\u0003-vs!aV.\u0011\u0005a#U\"A-\u000b\u0005i;\u0012A\u0002\u001fs_>$h(\u0003\u0002]\t\u00061\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\taF\tC\u0003b\u000f\u0001\u0007q%\u0001\u0006sKb\u0014U/\u001b7eKJ\u0004")
public class NestedSchemaRewriter
extends RexShuttle {
    private final NestedSchema schema;
    private final RexBuilder builder;

    @Override
    public RexNode visitInputRef(RexInputRef inputRef) {
        String name = this.schema.inputRowType().getFieldNames().get(inputRef.getIndex());
        if (!this.schema.columns().containsKey(name)) {
            throw new TableException(new StringBuilder(26).append("Illegal input field access").append(name).toString());
        }
        NestedColumn field = this.schema.columns().get(name);
        return new RexInputRef(field.indexOfLeafInNewSchema(), field.originFieldType());
    }

    @Override
    public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
        Tuple2<Option<RexNode>, NestedColumn> tuple2 = this.traverse(fieldAccess);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option node = (Option)tuple2._1();
        Option node2 = node;
        if (node2.isDefined()) {
            return (RexNode)node2.get();
        }
        throw new TableException(new StringBuilder(39).append("Unknown field ").append(fieldAccess).append(" when rewrite projection ").toString());
    }

    private Tuple2<Option<RexNode>, NestedColumn> traverse(RexFieldAccess fieldAccess) {
        RexNode rexNode = fieldAccess.getReferenceExpr();
        if (rexNode instanceof RexInputRef) {
            RexInputRef rexInputRef = (RexInputRef)rexNode;
            String name = this.schema.inputRowType().getFieldNames().get(rexInputRef.getIndex());
            NestedColumn parent = this.schema.columns().get(name);
            if (parent.isLeaf()) {
                return new Tuple2((Object)new Some((Object)this.copyFieldAccess(new RexInputRef(parent.indexOfLeafInNewSchema(), parent.originFieldType()), fieldAccess.getField().getName(), this.builder)), (Object)parent);
            }
            NestedColumn child = parent.children().get(fieldAccess.getField().getName());
            if (child.isLeaf()) {
                return new Tuple2((Object)new Some((Object)new RexInputRef(child.indexOfLeafInNewSchema(), child.originFieldType())), (Object)child);
            }
            return new Tuple2((Object)Option$.MODULE$.empty(), (Object)child);
        }
        if (rexNode instanceof RexFieldAccess) {
            RexFieldAccess rexFieldAccess = (RexFieldAccess)rexNode;
            Tuple2<Option<RexNode>, NestedColumn> tuple2 = this.traverse(rexFieldAccess);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option field = (Option)tuple2._1();
            NestedColumn parent = (NestedColumn)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)field, (Object)parent);
            Option field2 = (Option)tuple22._1();
            NestedColumn parent2 = (NestedColumn)tuple22._2();
            if (field2.isDefined()) {
                return new Tuple2((Object)new Some((Object)this.copyFieldAccess((RexNode)field2.get(), fieldAccess.getField().getName(), this.builder)), (Object)parent2);
            }
            NestedColumn child = parent2.children().get(fieldAccess.getField().getName());
            if (child.isLeaf()) {
                return new Tuple2((Object)new Some((Object)new RexInputRef(child.indexOfLeafInNewSchema(), child.originFieldType())), (Object)child);
            }
            return new Tuple2((Object)Option$.MODULE$.empty(), (Object)child);
        }
        RexNode newExpr = rexNode.accept(this);
        return new Tuple2((Object)new Some((Object)this.copyFieldAccess(newExpr, fieldAccess.getField().getName(), this.builder)), null);
    }

    private RexNode copyFieldAccess(RexNode newExpr, String fieldName, RexBuilder rexBuilder) {
        RexNode fieldAccess = rexBuilder.makeFieldAccess(newExpr, fieldName, true);
        RexNode rexNode = fieldAccess;
        if (rexNode instanceof RexCall) {
            RexCall rexCall = (RexCall)rexNode;
            return rexCall.getOperands().get(0);
        }
        return fieldAccess;
    }

    public NestedSchemaRewriter(NestedSchema schema, RexBuilder builder) {
        this.schema = schema;
        this.builder = builder;
    }
}

