/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.utils;

import java.util.Iterator;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.operators.join.stream.utils.AssociatedRecords;
import org.apache.flink.table.runtime.operators.join.stream.utils.OuterRecord;
import org.apache.flink.types.RowKind;

public abstract class JoinHelper<STATE_VIEW, OUTER_STATE_VIEW extends STATE_VIEW> {
    private final boolean leftIsOuter;
    private final boolean rightIsOuter;
    private final JoinedRowData outRow;
    private final RowData leftNullRow;
    private final RowData rightNullRow;
    private final TimestampedCollector<RowData> collector;

    public JoinHelper(boolean leftIsOuter, boolean rightIsOuter, JoinedRowData outRow, RowData leftNullRow, RowData rightNullRow, TimestampedCollector<RowData> collector) {
        this.leftIsOuter = leftIsOuter;
        this.rightIsOuter = rightIsOuter;
        this.outRow = outRow;
        this.leftNullRow = leftNullRow;
        this.rightNullRow = rightNullRow;
        this.collector = collector;
    }

    public void processJoin(RowData input, STATE_VIEW inputSideAsyncStateView, STATE_VIEW otherSideAsyncStateView, boolean inputIsLeft, AssociatedRecords otherSideAssociatedRecords, boolean isSuppress) throws Exception {
        block20: {
            RowKind inputRowKind;
            boolean otherIsOuter;
            boolean inputIsOuter;
            block21: {
                block18: {
                    block19: {
                        inputIsOuter = inputIsLeft ? this.leftIsOuter : this.rightIsOuter;
                        otherIsOuter = inputIsLeft ? this.rightIsOuter : this.leftIsOuter;
                        boolean isAccumulateMsg = RowDataUtil.isAccumulateMsg(input);
                        inputRowKind = input.getRowKind();
                        input.setRowKind(RowKind.INSERT);
                        if (!isAccumulateMsg) break block18;
                        if (!inputIsOuter) break block19;
                        STATE_VIEW inputSideOuterStateView = inputSideAsyncStateView;
                        if (otherSideAssociatedRecords.isEmpty()) {
                            this.outRow.setRowKind(RowKind.INSERT);
                            this.outputNullPadding(input, inputIsLeft);
                            this.addRecordInOuterSide(inputSideOuterStateView, input, 0);
                        } else {
                            if (otherIsOuter) {
                                STATE_VIEW otherSideOuterStateView = otherSideAsyncStateView;
                                for (OuterRecord outerRecord : otherSideAssociatedRecords.getOuterRecords()) {
                                    RowData other = outerRecord.record;
                                    if (outerRecord.numOfAssociations == 0 && !isSuppress) {
                                        this.outRow.setRowKind(RowKind.DELETE);
                                        this.outputNullPadding(other, !inputIsLeft);
                                    }
                                    this.updateNumOfAssociationsInOuterSide(otherSideOuterStateView, other, outerRecord.numOfAssociations + 1);
                                }
                            }
                            this.outRow.setRowKind(RowKind.INSERT);
                            for (RowData other : otherSideAssociatedRecords.getRecords()) {
                                this.output(input, other, inputIsLeft);
                            }
                            this.addRecordInOuterSide(inputSideOuterStateView, input, otherSideAssociatedRecords.size());
                        }
                        break block20;
                    }
                    this.addRecord(inputSideAsyncStateView, input);
                    if (otherSideAssociatedRecords.isEmpty()) break block20;
                    if (otherIsOuter) {
                        STATE_VIEW otherSideOuterStateView = otherSideAsyncStateView;
                        for (OuterRecord outerRecord : otherSideAssociatedRecords.getOuterRecords()) {
                            if (outerRecord.numOfAssociations == 0 && !isSuppress) {
                                this.outRow.setRowKind(RowKind.DELETE);
                                this.outputNullPadding(outerRecord.record, !inputIsLeft);
                            }
                            this.updateNumOfAssociationsInOuterSide(otherSideOuterStateView, outerRecord.record, outerRecord.numOfAssociations + 1);
                        }
                        this.outRow.setRowKind(RowKind.INSERT);
                    } else {
                        this.outRow.setRowKind(inputRowKind);
                    }
                    for (RowData other : otherSideAssociatedRecords.getRecords()) {
                        this.output(input, other, inputIsLeft);
                    }
                    break block20;
                }
                if (!isSuppress) {
                    this.retractRecord(inputSideAsyncStateView, input);
                }
                if (!otherSideAssociatedRecords.isEmpty()) break block21;
                if (!inputIsOuter) break block20;
                this.outRow.setRowKind(RowKind.DELETE);
                this.outputNullPadding(input, inputIsLeft);
                break block20;
            }
            if (inputIsOuter) {
                this.outRow.setRowKind(RowKind.DELETE);
            } else {
                this.outRow.setRowKind(inputRowKind);
            }
            for (RowData other : otherSideAssociatedRecords.getRecords()) {
                this.output(input, other, inputIsLeft);
            }
            if (otherIsOuter) {
                Iterator<Object> otherSideOuterStateView = otherSideAsyncStateView;
                for (OuterRecord outerRecord : otherSideAssociatedRecords.getOuterRecords()) {
                    if (outerRecord.numOfAssociations == 1 && !isSuppress) {
                        this.outRow.setRowKind(RowKind.INSERT);
                        this.outputNullPadding(outerRecord.record, !inputIsLeft);
                    }
                    this.updateNumOfAssociationsInOuterSide(otherSideOuterStateView, outerRecord.record, outerRecord.numOfAssociations - 1);
                }
            }
        }
    }

    public abstract void addRecord(STATE_VIEW var1, RowData var2) throws Exception;

    public abstract void retractRecord(STATE_VIEW var1, RowData var2) throws Exception;

    public abstract void addRecordInOuterSide(OUTER_STATE_VIEW var1, RowData var2, int var3) throws Exception;

    public abstract void updateNumOfAssociationsInOuterSide(OUTER_STATE_VIEW var1, RowData var2, int var3) throws Exception;

    private void output(RowData inputRow, RowData otherRow, boolean inputIsLeft) {
        if (inputIsLeft) {
            this.outRow.replace(inputRow, otherRow);
        } else {
            this.outRow.replace(otherRow, inputRow);
        }
        this.collector.collect((Object)this.outRow);
    }

    private void outputNullPadding(RowData row, boolean isLeft) {
        if (isLeft) {
            this.outRow.replace(row, this.rightNullRow);
        } else {
            this.outRow.replace(this.leftNullRow, row);
        }
        this.collector.collect((Object)this.outRow);
    }
}

