/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;

@PublicEvolving
public final class UnresolvedDataType
implements AbstractDataType<UnresolvedDataType> {
    private static final String FORMAT = "[%s]";
    @Nullable
    private final Boolean isNullable;
    @Nullable
    private final Class<?> conversionClass;
    private final Supplier<String> description;
    private final Function<DataTypeFactory, DataType> resolutionFactory;

    private UnresolvedDataType(@Nullable Boolean isNullable, @Nullable Class<?> conversionClass, Supplier<String> description, Function<DataTypeFactory, DataType> resolutionFactory) {
        this.isNullable = isNullable;
        this.conversionClass = conversionClass;
        this.description = description;
        this.resolutionFactory = resolutionFactory;
    }

    public UnresolvedDataType(Supplier<String> description, Function<DataTypeFactory, DataType> resolutionFactory) {
        this(null, null, description, resolutionFactory);
    }

    public DataType toDataType(DataTypeFactory factory) {
        DataType resolvedDataType = this.resolutionFactory.apply(factory);
        if (this.isNullable == Boolean.TRUE) {
            resolvedDataType = (DataType)resolvedDataType.nullable();
        } else if (this.isNullable == Boolean.FALSE) {
            resolvedDataType = (DataType)resolvedDataType.notNull();
        }
        if (this.conversionClass != null) {
            resolvedDataType = (DataType)resolvedDataType.bridgedTo(this.conversionClass);
        }
        return resolvedDataType;
    }

    @Override
    public UnresolvedDataType notNull() {
        return new UnresolvedDataType(false, this.conversionClass, this.description, this.resolutionFactory);
    }

    @Override
    public UnresolvedDataType nullable() {
        return new UnresolvedDataType(true, this.conversionClass, this.description, this.resolutionFactory);
    }

    @Override
    public UnresolvedDataType bridgedTo(Class<?> newConversionClass) {
        return new UnresolvedDataType(this.isNullable, newConversionClass, this.description, this.resolutionFactory);
    }

    public String toString() {
        return String.format(FORMAT, this.description.get());
    }
}

