/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccessTokenProvider {
    private AzureADToken token;
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenProvider.class);
    private static final long FIVE_MINUTES = 300000L;

    public synchronized AzureADToken getToken() throws IOException {
        if (this.isTokenAboutToExpire()) {
            LOG.debug("AAD Token is missing or expired: Calling refresh-token from abstract base class");
            this.token = this.refreshToken();
        }
        return this.token;
    }

    protected abstract AzureADToken refreshToken() throws IOException;

    protected boolean isTokenAboutToExpire() {
        if (this.token == null) {
            LOG.debug("AADToken: no token. Returning expiring=true");
            return true;
        }
        boolean expiring = false;
        long approximatelyNow = System.currentTimeMillis() + 300000L;
        if (this.token.getExpiry().getTime() < approximatelyNow) {
            expiring = true;
        }
        if (expiring) {
            LOG.debug("AADToken: token expiring: " + this.token.getExpiry().toString() + " : Five-minute window: " + new Date(approximatelyNow).toString());
        }
        return expiring;
    }
}

