/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.source;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.lib.util.IteratorSourceReaderBase;
import org.apache.flink.api.connector.source.lib.util.IteratorSourceSplit;
import org.apache.flink.connector.datagen.source.GeneratorFunction;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

@Experimental
public class DoubleEmittingSourceReaderWithCheckpointsInBetween<E, O, IterT extends Iterator<E>, SplitT extends IteratorSourceSplit<E, IterT>>
extends IteratorSourceReaderBase<E, O, IterT, SplitT> {
    private final GeneratorFunction<E, O> generatorFunction;
    private BooleanSupplier allowedToExit;
    private int snapshotsCompleted;
    private int snapshotsToWaitFor;
    private boolean done;

    public DoubleEmittingSourceReaderWithCheckpointsInBetween(SourceReaderContext context, GeneratorFunction<E, O> generatorFunction, @Nullable BooleanSupplier allowedToExit) {
        super(context);
        this.generatorFunction = (GeneratorFunction)Preconditions.checkNotNull(generatorFunction);
        this.allowedToExit = allowedToExit;
    }

    public DoubleEmittingSourceReaderWithCheckpointsInBetween(SourceReaderContext context, GeneratorFunction<E, O> generatorFunction) {
        super(context);
        this.generatorFunction = (GeneratorFunction)Preconditions.checkNotNull(generatorFunction);
    }

    public void start(SourceReaderContext context) {
        try {
            this.generatorFunction.open(context);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to open the GeneratorFunction", (Throwable)e);
        }
    }

    public InputStatus pollNext(ReaderOutput<O> output) {
        if (this.done) {
            if (this.allowedToExit != null) {
                return this.allowedToExit.getAsBoolean() ? InputStatus.END_OF_INPUT : InputStatus.NOTHING_AVAILABLE;
            }
            return InputStatus.END_OF_INPUT;
        }
        if (this.currentSplit == null) {
            InputStatus inputStatus = this.tryMoveToNextSplit();
            switch (inputStatus) {
                case MORE_AVAILABLE: {
                    this.emitElements(output);
                    break;
                }
                case END_OF_INPUT: {
                    return inputStatus;
                }
            }
        } else {
            this.emitElements(output);
            this.done = true;
        }
        this.availability = new CompletableFuture();
        return InputStatus.NOTHING_AVAILABLE;
    }

    private void emitElements(ReaderOutput<O> output) {
        this.iterator = this.currentSplit.getIterator();
        while (this.iterator.hasNext()) {
            Object next = this.iterator.next();
            O converted = this.convert(next);
            output.collect(converted);
        }
        this.snapshotsToWaitFor = 2;
        this.snapshotsCompleted = 0;
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        ++this.snapshotsCompleted;
        if (this.snapshotsCompleted >= this.snapshotsToWaitFor) {
            this.availability.complete(null);
        }
        if (this.allowedToExit != null && this.allowedToExit.getAsBoolean()) {
            this.availability.complete(null);
        }
    }

    protected O convert(E value) {
        try {
            return this.generatorFunction.map(value);
        }
        catch (Exception e) {
            String message = String.format("A user-provided generator function threw an exception on this input: %s", value.toString());
            throw new FlinkRuntimeException(message, (Throwable)e);
        }
    }
}

