/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.Optional;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ContextResolvedModel;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public abstract class AbstractSqlAlterModelConverter<T extends SqlNode>
implements SqlNodeConverter<T> {
    protected ResolvedCatalogModel getExistingModel(SqlNodeConverter.ConvertContext context, String[] fullModelName, boolean ifModelExists) {
        UnresolvedIdentifier unresolvedIdentifier;
        ObjectIdentifier modelIdentifier;
        CatalogManager catalogManager = context.getCatalogManager();
        Optional optionalCatalogModel = catalogManager.getModel(modelIdentifier = catalogManager.qualifyIdentifier(unresolvedIdentifier = UnresolvedIdentifier.of((String[])fullModelName)));
        if (optionalCatalogModel.isEmpty() || ((ContextResolvedModel)optionalCatalogModel.get()).isTemporary()) {
            if (optionalCatalogModel.isEmpty()) {
                if (!ifModelExists) {
                    throw new ValidationException(String.format("Model %s doesn't exist.", modelIdentifier));
                }
            } else {
                throw new ValidationException(String.format("Model %s is a temporary model.", modelIdentifier));
            }
        }
        return optionalCatalogModel.map(ContextResolvedModel::getResolvedModel).orElse(null);
    }
}

