/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.DefaultResolvedCatalogModel;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.plan.nodes.exec.serde.CompiledPlanSerdeUtil;

@Internal
public class ResolvedCatalogModelJsonDeserializer
extends StdDeserializer<ResolvedCatalogModel> {
    private static final long serialVersionUID = 1L;

    public ResolvedCatalogModelJsonDeserializer() {
        super(ResolvedCatalogModel.class);
    }

    public ResolvedCatalogModel deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        ObjectNode jsonNode = (ObjectNode)jsonParser.readValueAsTree();
        ObjectCodec codec = jsonParser.getCodec();
        ResolvedSchema inputSchema = (ResolvedSchema)ctx.readValue(CompiledPlanSerdeUtil.traverse((TreeNode)jsonNode.required("inputSchema"), codec), ResolvedSchema.class);
        ResolvedSchema outputSchema = (ResolvedSchema)ctx.readValue(CompiledPlanSerdeUtil.traverse((TreeNode)jsonNode.required("outputSchema"), codec), ResolvedSchema.class);
        String comment = CompiledPlanSerdeUtil.deserializeFieldOrNull(jsonNode, "comment", String.class, codec, ctx);
        Map<String, String> options = CompiledPlanSerdeUtil.deserializeMapOrEmpty(jsonNode, "options", String.class, String.class, codec, ctx);
        return new DefaultResolvedCatalogModel(CatalogModel.of((Schema)Schema.newBuilder().fromResolvedSchema(inputSchema).build(), (Schema)Schema.newBuilder().fromResolvedSchema(outputSchema).build(), options, (String)comment), inputSchema, outputSchema);
    }
}

