/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.flink.table.api.typeutils

import org.apache.flink.annotation.Internal
import org.apache.flink.api.common.typeutils.{TypeSerializer, TypeSerializerSnapshot}

/** Serializer for [[Tuple2]]. */
@Internal
@SerialVersionUID(1L)
class Tuple2CaseClassSerializer[T1, T2](
    val clazz: Class[(T1, T2)],
    fieldSerializers: Array[TypeSerializer[_]]
) extends ScalaCaseClassSerializer[(T1, T2)](clazz, fieldSerializers) {

  override def createInstance(fields: Array[AnyRef]): (T1, T2) = {
    (fields(0).asInstanceOf[T1], fields(1).asInstanceOf[T2])
  }

  override def snapshotConfiguration(): TypeSerializerSnapshot[(T1, T2)] = {
    new Tuple2CaseClassSerializerSnapshot[T1, T2](this)
  }
}
