/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.reader.fetcher;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.connector.base.source.reader.fetcher.SplitFetcherTask;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsRemoval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class RemoveSplitsTask<SplitT extends SourceSplit>
implements SplitFetcherTask {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveSplitsTask.class);
    private final SplitReader<?, SplitT> splitReader;
    private final List<SplitT> removedSplits;
    private final Map<String, SplitT> assignedSplits;
    private final Consumer<Collection<String>> splitFinishedCallback;

    RemoveSplitsTask(SplitReader<?, SplitT> splitReader, List<SplitT> removedSplits, Map<String, SplitT> assignedSplits, Consumer<Collection<String>> splitFinishedCallback) {
        this.splitReader = splitReader;
        this.removedSplits = removedSplits;
        this.assignedSplits = assignedSplits;
        this.splitFinishedCallback = splitFinishedCallback;
    }

    @Override
    public boolean run() {
        for (SourceSplit s : this.removedSplits) {
            this.assignedSplits.remove(s.splitId());
        }
        this.splitReader.handleSplitsChanges(new SplitsRemoval<SplitT>(this.removedSplits));
        List splitIds = this.removedSplits.stream().map(SourceSplit::splitId).collect(Collectors.toList());
        this.splitFinishedCallback.accept(splitIds);
        LOG.info("RecordEvaluator triggers splits {} to finish reading.", splitIds);
        return true;
    }

    @Override
    public void wakeUp() {
    }

    public String toString() {
        return String.format("RemoveSplitsTask: [%s]", this.removedSplits);
    }
}

