/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.31.1(337587859b1c171314b40503171188b6cea6a32a)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
define("vs/language/typescript/tsMode",[],()=>{
var moduleExports=(()=>{var le=Object.create;var w=Object.defineProperty;var ce=Object.getOwnPropertyDescriptor;var ue=Object.getOwnPropertyNames;var pe=Object.getPrototypeOf,ge=Object.prototype.hasOwnProperty;var T=n=>w(n,"__esModule",{value:!0});var te=(n=>typeof require!="undefined"?require:typeof Proxy!="undefined"?new Proxy(n,{get:(e,t)=>(typeof require!="undefined"?require:e)[t]}):n)(function(n){if(typeof require!="undefined")return require.apply(this,arguments);throw new Error('Dynamic require of "'+n+'" is not supported')});var de=(n,e)=>()=>(e||n((e={exports:{}}).exports,e),e.exports),me=(n,e)=>{T(n);for(var t in e)w(n,t,{get:e[t],enumerable:!0})},F=(n,e,t)=>{if(e&&typeof e=="object"||typeof e=="function")for(let i of ue(e))!ge.call(n,i)&&i!=="default"&&w(n,i,{get:()=>e[i],enumerable:!(t=ce(e,i))||t.enumerable});return n},be=n=>F(T(w(n!=null?le(pe(n)):{},"default",n&&n.__esModule&&"default"in n?{get:()=>n.default,enumerable:!0}:{value:n,enumerable:!0})),n);var re=de((De,ie)=>{ie.exports=self.monaco});var _e={};me(_e,{getJavaScriptWorker:()=>ke,getTypeScriptWorker:()=>Se,setupJavaScript:()=>ve,setupTypeScript:()=>xe});var r={};T(r);F(r,be(re()));var E=class{constructor(e,t){this._modeId=e,this._defaults=t,this._worker=null,this._client=null,this._configChangeListener=this._defaults.onDidChange(()=>this._stopWorker()),this._updateExtraLibsToken=0,this._extraLibsChangeListener=this._defaults.onDidExtraLibsChange(()=>this._updateExtraLibs())}_stopWorker(){this._worker&&(this._worker.dispose(),this._worker=null),this._client=null}dispose(){this._configChangeListener.dispose(),this._extraLibsChangeListener.dispose(),this._stopWorker()}async _updateExtraLibs(){if(!this._worker)return;let e=++this._updateExtraLibsToken,t=await this._worker.getProxy();this._updateExtraLibsToken===e&&t.updateExtraLibs(this._defaults.getExtraLibs())}_getClient(){if(!this._client){this._worker=r.editor.createWebWorker({moduleId:"vs/language/typescript/tsWorker",label:this._modeId,keepIdleModels:!0,createData:{compilerOptions:this._defaults.getCompilerOptions(),extraLibs:this._defaults.getExtraLibs(),customWorkerPath:this._defaults.workerOptions.customWorkerPath,inlayHintsOptions:this._defaults.inlayHintsOptions}});let e=this._worker.getProxy();this._defaults.getEagerModelSync()&&(e=e.then(t=>this._worker?this._worker.withSyncedResources(r.editor.getModels().filter(i=>i.getLanguageId()===this._modeId).map(i=>i.uri)):t)),this._client=e}return this._client}getLanguageServiceWorker(...e){let t;return this._getClient().then(i=>{t=i}).then(i=>{if(this._worker)return this._worker.withSyncedResources(e)}).then(i=>t)}};var ne="4.4.4";var M;(function(a){a[a.None=0]="None",a[a.CommonJS=1]="CommonJS",a[a.AMD=2]="AMD",a[a.UMD=3]="UMD",a[a.System=4]="System",a[a.ES2015=5]="ES2015",a[a.ESNext=99]="ESNext"})(M||(M={}));var A;(function(p){p[p.None=0]="None",p[p.Preserve=1]="Preserve",p[p.React=2]="React",p[p.ReactNative=3]="ReactNative",p[p.ReactJSX=4]="ReactJSX",p[p.ReactJSXDev=5]="ReactJSXDev"})(A||(A={}));var N;(function(t){t[t.CarriageReturnLineFeed=0]="CarriageReturnLineFeed",t[t.LineFeed=1]="LineFeed"})(N||(N={}));var D;(function(g){g[g.ES3=0]="ES3",g[g.ES5=1]="ES5",g[g.ES2015=2]="ES2015",g[g.ES2016=3]="ES2016",g[g.ES2017=4]="ES2017",g[g.ES2018=5]="ES2018",g[g.ES2019=6]="ES2019",g[g.ES2020=7]="ES2020",g[g.ESNext=99]="ESNext",g[g.JSON=100]="JSON",g[g.Latest=99]="Latest"})(D||(D={}));var R;(function(t){t[t.Classic=1]="Classic",t[t.NodeJs=2]="NodeJs"})(R||(R={}));var W=class{constructor(e,t,i,s){this._onDidChange=new r.Emitter;this._onDidExtraLibsChange=new r.Emitter;this._extraLibs=Object.create(null),this._removedExtraLibs=Object.create(null),this._eagerModelSync=!1,this.setCompilerOptions(e),this.setDiagnosticsOptions(t),this.setWorkerOptions(i),this.setInlayHintsOptions(s),this._onDidExtraLibsChangeTimeout=-1}get onDidChange(){return this._onDidChange.event}get onDidExtraLibsChange(){return this._onDidExtraLibsChange.event}get workerOptions(){return this._workerOptions}get inlayHintsOptions(){return this._inlayHintsOptions}getExtraLibs(){return this._extraLibs}addExtraLib(e,t){let i;if(typeof t=="undefined"?i=`ts:extralib-${Math.random().toString(36).substring(2,15)}`:i=t,this._extraLibs[i]&&this._extraLibs[i].content===e)return{dispose:()=>{}};let s=1;return this._removedExtraLibs[i]&&(s=this._removedExtraLibs[i]+1),this._extraLibs[i]&&(s=this._extraLibs[i].version+1),this._extraLibs[i]={content:e,version:s},this._fireOnDidExtraLibsChangeSoon(),{dispose:()=>{let u=this._extraLibs[i];!u||u.version===s&&(delete this._extraLibs[i],this._removedExtraLibs[i]=s,this._fireOnDidExtraLibsChangeSoon())}}}setExtraLibs(e){for(let t in this._extraLibs)this._removedExtraLibs[t]=this._extraLibs[t].version;if(this._extraLibs=Object.create(null),e&&e.length>0)for(let t of e){let i=t.filePath||`ts:extralib-${Math.random().toString(36).substring(2,15)}`,s=t.content,u=1;this._removedExtraLibs[i]&&(u=this._removedExtraLibs[i]+1),this._extraLibs[i]={content:s,version:u}}this._fireOnDidExtraLibsChangeSoon()}_fireOnDidExtraLibsChangeSoon(){this._onDidExtraLibsChangeTimeout===-1&&(this._onDidExtraLibsChangeTimeout=window.setTimeout(()=>{this._onDidExtraLibsChangeTimeout=-1,this._onDidExtraLibsChange.fire(void 0)},0))}getCompilerOptions(){return this._compilerOptions}setCompilerOptions(e){this._compilerOptions=e||Object.create(null),this._onDidChange.fire(void 0)}getDiagnosticsOptions(){return this._diagnosticsOptions}setDiagnosticsOptions(e){this._diagnosticsOptions=e||Object.create(null),this._onDidChange.fire(void 0)}setWorkerOptions(e){this._workerOptions=e||Object.create(null),this._onDidChange.fire(void 0)}setInlayHintsOptions(e){this._inlayHintsOptions=e||Object.create(null),this._onDidChange.fire(void 0)}setMaximumWorkerIdleTime(e){}setEagerModelSync(e){this._eagerModelSync=e}getEagerModelSync(){return this._eagerModelSync}},fe=ne,L=new W({allowNonTsExtensions:!0,target:99},{noSemanticValidation:!1,noSyntaxValidation:!1,onlyVisible:!1},{},{}),se=new W({allowNonTsExtensions:!0,allowJs:!0,target:99},{noSemanticValidation:!0,noSyntaxValidation:!1,onlyVisible:!1},{},{}),he=()=>O().then(n=>n.getTypeScriptWorker()),ye=()=>O().then(n=>n.getJavaScriptWorker());r.languages.typescript={ModuleKind:M,JsxEmit:A,NewLineKind:N,ScriptTarget:D,ModuleResolutionKind:R,typescriptVersion:fe,typescriptDefaults:L,javascriptDefaults:se,getTypeScriptWorker:he,getJavaScriptWorker:ye};function O(){return new Promise((n,e)=>{te(["vs/language/typescript/tsMode"],n,e)})}r.languages.onLanguage("typescript",()=>O().then(n=>n.setupTypeScript(L)));r.languages.onLanguage("javascript",()=>O().then(n=>n.setupJavaScript(se)));var l={};l["lib.d.ts"]=!0;l["lib.dom.d.ts"]=!0;l["lib.dom.iterable.d.ts"]=!0;l["lib.es2015.collection.d.ts"]=!0;l["lib.es2015.core.d.ts"]=!0;l["lib.es2015.d.ts"]=!0;l["lib.es2015.generator.d.ts"]=!0;l["lib.es2015.iterable.d.ts"]=!0;l["lib.es2015.promise.d.ts"]=!0;l["lib.es2015.proxy.d.ts"]=!0;l["lib.es2015.reflect.d.ts"]=!0;l["lib.es2015.symbol.d.ts"]=!0;l["lib.es2015.symbol.wellknown.d.ts"]=!0;l["lib.es2016.array.include.d.ts"]=!0;l["lib.es2016.d.ts"]=!0;l["lib.es2016.full.d.ts"]=!0;l["lib.es2017.d.ts"]=!0;l["lib.es2017.full.d.ts"]=!0;l["lib.es2017.intl.d.ts"]=!0;l["lib.es2017.object.d.ts"]=!0;l["lib.es2017.sharedmemory.d.ts"]=!0;l["lib.es2017.string.d.ts"]=!0;l["lib.es2017.typedarrays.d.ts"]=!0;l["lib.es2018.asyncgenerator.d.ts"]=!0;l["lib.es2018.asynciterable.d.ts"]=!0;l["lib.es2018.d.ts"]=!0;l["lib.es2018.full.d.ts"]=!0;l["lib.es2018.intl.d.ts"]=!0;l["lib.es2018.promise.d.ts"]=!0;l["lib.es2018.regexp.d.ts"]=!0;l["lib.es2019.array.d.ts"]=!0;l["lib.es2019.d.ts"]=!0;l["lib.es2019.full.d.ts"]=!0;l["lib.es2019.object.d.ts"]=!0;l["lib.es2019.string.d.ts"]=!0;l["lib.es2019.symbol.d.ts"]=!0;l["lib.es2020.bigint.d.ts"]=!0;l["lib.es2020.d.ts"]=!0;l["lib.es2020.full.d.ts"]=!0;l["lib.es2020.intl.d.ts"]=!0;l["lib.es2020.promise.d.ts"]=!0;l["lib.es2020.sharedmemory.d.ts"]=!0;l["lib.es2020.string.d.ts"]=!0;l["lib.es2020.symbol.wellknown.d.ts"]=!0;l["lib.es2021.d.ts"]=!0;l["lib.es2021.full.d.ts"]=!0;l["lib.es2021.promise.d.ts"]=!0;l["lib.es2021.string.d.ts"]=!0;l["lib.es2021.weakref.d.ts"]=!0;l["lib.es5.d.ts"]=!0;l["lib.es6.d.ts"]=!0;l["lib.esnext.d.ts"]=!0;l["lib.esnext.full.d.ts"]=!0;l["lib.esnext.intl.d.ts"]=!0;l["lib.esnext.promise.d.ts"]=!0;l["lib.esnext.string.d.ts"]=!0;l["lib.esnext.weakref.d.ts"]=!0;l["lib.scripthost.d.ts"]=!0;l["lib.webworker.d.ts"]=!0;l["lib.webworker.importscripts.d.ts"]=!0;l["lib.webworker.iterable.d.ts"]=!0;var H;(function(i){i[i.None=0]="None",i[i.Block=1]="Block",i[i.Smart=2]="Smart"})(H||(H={}));function V(n,e,t=0){if(typeof n=="string")return n;if(n===void 0)return"";let i="";if(t){i+=e;for(let s=0;s<t;s++)i+="  "}if(i+=n.messageText,t++,n.next)for(let s of n.next)i+=V(s,e,t);return i}function x(n){return n?n.map(e=>e.text).join(""):""}var y=class{constructor(e){this._worker=e}_textSpanToRange(e,t){let i=e.getPositionAt(t.start),s=e.getPositionAt(t.start+t.length),{lineNumber:u,column:p}=i,{lineNumber:a,column:o}=s;return{startLineNumber:u,startColumn:p,endLineNumber:a,endColumn:o}}},U=class{constructor(e){this._worker=e;this._libFiles={},this._hasFetchedLibFiles=!1,this._fetchLibFilesPromise=null}isLibFile(e){return e&&e.path.indexOf("/lib.")===0?!!l[e.path.slice(1)]:!1}getOrCreateModel(e){let t=r.Uri.parse(e),i=r.editor.getModel(t);if(i)return i;if(this.isLibFile(t)&&this._hasFetchedLibFiles)return r.editor.createModel(this._libFiles[t.path.slice(1)],"typescript",t);let s=L.getExtraLibs()[e];return s?r.editor.createModel(s.content,"typescript",t):null}_containsLibFile(e){for(let t of e)if(this.isLibFile(t))return!0;return!1}async fetchLibFilesIfNecessary(e){!this._containsLibFile(e)||await this._fetchLibFiles()}_fetchLibFiles(){return this._fetchLibFilesPromise||(this._fetchLibFilesPromise=this._worker().then(e=>e.getLibFiles()).then(e=>{this._hasFetchedLibFiles=!0,this._libFiles=e})),this._fetchLibFilesPromise}},_;(function(s){s[s.Warning=0]="Warning",s[s.Error=1]="Error",s[s.Suggestion=2]="Suggestion",s[s.Message=3]="Message"})(_||(_={}));var j=class extends y{constructor(e,t,i,s){super(s);this._libFiles=e;this._defaults=t;this._selector=i;this._disposables=[];this._listener=Object.create(null);let u=o=>{if(o.getLanguageId()!==i)return;let m=()=>{let{onlyVisible:f}=this._defaults.getDiagnosticsOptions();f?o.isAttachedToEditor()&&this._doValidate(o):this._doValidate(o)},d,g=o.onDidChangeContent(()=>{clearTimeout(d),d=window.setTimeout(m,500)}),b=o.onDidChangeAttached(()=>{let{onlyVisible:f}=this._defaults.getDiagnosticsOptions();f&&(o.isAttachedToEditor()?m():r.editor.setModelMarkers(o,this._selector,[]))});this._listener[o.uri.toString()]={dispose(){g.dispose(),b.dispose(),clearTimeout(d)}},m()},p=o=>{r.editor.setModelMarkers(o,this._selector,[]);let m=o.uri.toString();this._listener[m]&&(this._listener[m].dispose(),delete this._listener[m])};this._disposables.push(r.editor.onDidCreateModel(o=>u(o))),this._disposables.push(r.editor.onWillDisposeModel(p)),this._disposables.push(r.editor.onDidChangeModelLanguage(o=>{p(o.model),u(o.model)})),this._disposables.push({dispose(){for(let o of r.editor.getModels())p(o)}});let a=()=>{for(let o of r.editor.getModels())p(o),u(o)};this._disposables.push(this._defaults.onDidChange(a)),this._disposables.push(this._defaults.onDidExtraLibsChange(a)),r.editor.getModels().forEach(o=>u(o))}dispose(){this._disposables.forEach(e=>e&&e.dispose()),this._disposables=[]}async _doValidate(e){let t=await this._worker(e.uri);if(e.isDisposed())return;let i=[],{noSyntaxValidation:s,noSemanticValidation:u,noSuggestionDiagnostics:p}=this._defaults.getDiagnosticsOptions();s||i.push(t.getSyntacticDiagnostics(e.uri.toString())),u||i.push(t.getSemanticDiagnostics(e.uri.toString())),p||i.push(t.getSuggestionDiagnostics(e.uri.toString()));let a=await Promise.all(i);if(!a||e.isDisposed())return;let o=a.reduce((d,g)=>g.concat(d),[]).filter(d=>(this._defaults.getDiagnosticsOptions().diagnosticCodesToIgnore||[]).indexOf(d.code)===-1),m=o.map(d=>d.relatedInformation||[]).reduce((d,g)=>g.concat(d),[]).map(d=>d.file?r.Uri.parse(d.file.fileName):null);await this._libFiles.fetchLibFilesIfNecessary(m),!e.isDisposed()&&r.editor.setModelMarkers(e,this._selector,o.map(d=>this._convertDiagnostics(e,d)))}_convertDiagnostics(e,t){let i=t.start||0,s=t.length||1,{lineNumber:u,column:p}=e.getPositionAt(i),{lineNumber:a,column:o}=e.getPositionAt(i+s),m=[];return t.reportsUnnecessary&&m.push(r.MarkerTag.Unnecessary),t.reportsDeprecated&&m.push(r.MarkerTag.Deprecated),{severity:this._tsDiagnosticCategoryToMarkerSeverity(t.category),startLineNumber:u,startColumn:p,endLineNumber:a,endColumn:o,message:V(t.messageText,`
`),code:t.code.toString(),tags:m,relatedInformation:this._convertRelatedInformation(e,t.relatedInformation)}}_convertRelatedInformation(e,t){if(!t)return[];let i=[];return t.forEach(s=>{let u=e;if(s.file&&(u=this._libFiles.getOrCreateModel(s.file.fileName)),!u)return;let p=s.start||0,a=s.length||1,{lineNumber:o,column:m}=u.getPositionAt(p),{lineNumber:d,column:g}=u.getPositionAt(p+a);i.push({resource:u.uri,startLineNumber:o,startColumn:m,endLineNumber:d,endColumn:g,message:V(s.messageText,`
`)})}),i}_tsDiagnosticCategoryToMarkerSeverity(e){switch(e){case 1:return r.MarkerSeverity.Error;case 3:return r.MarkerSeverity.Info;case 0:return r.MarkerSeverity.Warning;case 2:return r.MarkerSeverity.Hint}return r.MarkerSeverity.Info}},v=class extends y{get triggerCharacters(){return["."]}async provideCompletionItems(e,t,i,s){let u=e.getWordUntilPosition(t),p=new r.Range(t.lineNumber,u.startColumn,t.lineNumber,u.endColumn),a=e.uri,o=e.getOffsetAt(t),m=await this._worker(a);if(e.isDisposed())return;let d=await m.getCompletionsAtPosition(a.toString(),o);return!d||e.isDisposed()?void 0:{suggestions:d.entries.map(b=>{let f=p;if(b.replacementSpan){let C=e.getPositionAt(b.replacementSpan.start),P=e.getPositionAt(b.replacementSpan.start+b.replacementSpan.length);f=new r.Range(C.lineNumber,C.column,P.lineNumber,P.column)}let S=[];return b.kindModifiers?.indexOf("deprecated")!==-1&&S.push(r.languages.CompletionItemTag.Deprecated),{uri:a,position:t,offset:o,range:f,label:b.name,insertText:b.name,sortText:b.sortText,kind:v.convertKind(b.kind),tags:S}})}}async resolveCompletionItem(e,t){let i=e,s=i.uri,u=i.position,p=i.offset,o=await(await this._worker(s)).getCompletionEntryDetails(s.toString(),p,i.label);return o?{uri:s,position:u,label:o.name,kind:v.convertKind(o.kind),detail:x(o.displayParts),documentation:{value:v.createDocumentationString(o)}}:i}static convertKind(e){switch(e){case c.primitiveType:case c.keyword:return r.languages.CompletionItemKind.Keyword;case c.variable:case c.localVariable:return r.languages.CompletionItemKind.Variable;case c.memberVariable:case c.memberGetAccessor:case c.memberSetAccessor:return r.languages.CompletionItemKind.Field;case c.function:case c.memberFunction:case c.constructSignature:case c.callSignature:case c.indexSignature:return r.languages.CompletionItemKind.Function;case c.enum:return r.languages.CompletionItemKind.Enum;case c.module:return r.languages.CompletionItemKind.Module;case c.class:return r.languages.CompletionItemKind.Class;case c.interface:return r.languages.CompletionItemKind.Interface;case c.warning:return r.languages.CompletionItemKind.File}return r.languages.CompletionItemKind.Property}static createDocumentationString(e){let t=x(e.documentation);if(e.tags)for(let i of e.tags)t+=`

${oe(i)}`;return t}};function oe(n){let e=`*@${n.name}*`;if(n.name==="param"&&n.text){let[t,...i]=n.text;e+=`\`${t.text}\``,i.length>0&&(e+=` \u2014 ${i.map(s=>s.text).join(" ")}`)}else Array.isArray(n.text)?e+=` \u2014 ${n.text.map(t=>t.text).join(" ")}`:n.text&&(e+=` \u2014 ${n.text}`);return e}var I=class extends y{constructor(){super(...arguments);this.signatureHelpTriggerCharacters=["(",","]}static _toSignatureHelpTriggerReason(e){switch(e.triggerKind){case r.languages.SignatureHelpTriggerKind.TriggerCharacter:return e.triggerCharacter?e.isRetrigger?{kind:"retrigger",triggerCharacter:e.triggerCharacter}:{kind:"characterTyped",triggerCharacter:e.triggerCharacter}:{kind:"invoked"};case r.languages.SignatureHelpTriggerKind.ContentChange:return e.isRetrigger?{kind:"retrigger"}:{kind:"invoked"};case r.languages.SignatureHelpTriggerKind.Invoke:default:return{kind:"invoked"}}}async provideSignatureHelp(e,t,i,s){let u=e.uri,p=e.getOffsetAt(t),a=await this._worker(u);if(e.isDisposed())return;let o=await a.getSignatureHelpItems(u.toString(),p,{triggerReason:I._toSignatureHelpTriggerReason(s)});if(!o||e.isDisposed())return;let m={activeSignature:o.selectedItemIndex,activeParameter:o.argumentIndex,signatures:[]};return o.items.forEach(d=>{let g={label:"",parameters:[]};g.documentation={value:x(d.documentation)},g.label+=x(d.prefixDisplayParts),d.parameters.forEach((b,f,S)=>{let C=x(b.displayParts),P={label:C,documentation:{value:x(b.documentation)}};g.label+=C,g.parameters.push(P),f<S.length-1&&(g.label+=x(d.separatorDisplayParts))}),g.label+=x(d.suffixDisplayParts),m.signatures.push(g)}),{value:m,dispose(){}}}},B=class extends y{async provideHover(e,t,i){let s=e.uri,u=e.getOffsetAt(t),p=await this._worker(s);if(e.isDisposed())return;let a=await p.getQuickInfoAtPosition(s.toString(),u);if(!a||e.isDisposed())return;let o=x(a.documentation),m=a.tags?a.tags.map(g=>oe(g)).join(`  

`):"",d=x(a.displayParts);return{range:this._textSpanToRange(e,a.textSpan),contents:[{value:"```typescript\n"+d+"\n```\n"},{value:o+(m?`

`+m:"")}]}}},$=class extends y{async provideDocumentHighlights(e,t,i){let s=e.uri,u=e.getOffsetAt(t),p=await this._worker(s);if(e.isDisposed())return;let a=await p.getOccurrencesAtPosition(s.toString(),u);if(!(!a||e.isDisposed()))return a.map(o=>({range:this._textSpanToRange(e,o.textSpan),kind:o.isWriteAccess?r.languages.DocumentHighlightKind.Write:r.languages.DocumentHighlightKind.Text}))}},z=class extends y{constructor(e,t){super(t);this._libFiles=e}async provideDefinition(e,t,i){let s=e.uri,u=e.getOffsetAt(t),p=await this._worker(s);if(e.isDisposed())return;let a=await p.getDefinitionAtPosition(s.toString(),u);if(!a||e.isDisposed()||(await this._libFiles.fetchLibFilesIfNecessary(a.map(m=>r.Uri.parse(m.fileName))),e.isDisposed()))return;let o=[];for(let m of a){let d=this._libFiles.getOrCreateModel(m.fileName);d&&o.push({uri:d.uri,range:this._textSpanToRange(d,m.textSpan)})}return o}},G=class extends y{constructor(e,t){super(t);this._libFiles=e}async provideReferences(e,t,i,s){let u=e.uri,p=e.getOffsetAt(t),a=await this._worker(u);if(e.isDisposed())return;let o=await a.getReferencesAtPosition(u.toString(),p);if(!o||e.isDisposed()||(await this._libFiles.fetchLibFilesIfNecessary(o.map(d=>r.Uri.parse(d.fileName))),e.isDisposed()))return;let m=[];for(let d of o){let g=this._libFiles.getOrCreateModel(d.fileName);g&&m.push({uri:g.uri,range:this._textSpanToRange(g,d.textSpan)})}return m}},J=class extends y{async provideDocumentSymbols(e,t){let i=e.uri,s=await this._worker(i);if(e.isDisposed())return;let u=await s.getNavigationBarItems(i.toString());if(!u||e.isDisposed())return;let p=(o,m,d)=>{let g={name:m.text,detail:"",kind:h[m.kind]||r.languages.SymbolKind.Variable,range:this._textSpanToRange(e,m.spans[0]),selectionRange:this._textSpanToRange(e,m.spans[0]),tags:[]};if(d&&(g.containerName=d),m.childItems&&m.childItems.length>0)for(let b of m.childItems)p(o,b,g.name);o.push(g)},a=[];return u.forEach(o=>p(a,o)),a}},c=class{};c.unknown="",c.keyword="keyword",c.script="script",c.module="module",c.class="class",c.interface="interface",c.type="type",c.enum="enum",c.variable="var",c.localVariable="local var",c.function="function",c.localFunction="local function",c.memberFunction="method",c.memberGetAccessor="getter",c.memberSetAccessor="setter",c.memberVariable="property",c.constructorImplementation="constructor",c.callSignature="call",c.indexSignature="index",c.constructSignature="construct",c.parameter="parameter",c.typeParameter="type parameter",c.primitiveType="primitive type",c.label="label",c.alias="alias",c.const="const",c.let="let",c.warning="warning";var h=Object.create(null);h[c.module]=r.languages.SymbolKind.Module;h[c.class]=r.languages.SymbolKind.Class;h[c.enum]=r.languages.SymbolKind.Enum;h[c.interface]=r.languages.SymbolKind.Interface;h[c.memberFunction]=r.languages.SymbolKind.Method;h[c.memberVariable]=r.languages.SymbolKind.Property;h[c.memberGetAccessor]=r.languages.SymbolKind.Property;h[c.memberSetAccessor]=r.languages.SymbolKind.Property;h[c.variable]=r.languages.SymbolKind.Variable;h[c.const]=r.languages.SymbolKind.Variable;h[c.localVariable]=r.languages.SymbolKind.Variable;h[c.variable]=r.languages.SymbolKind.Variable;h[c.function]=r.languages.SymbolKind.Function;h[c.localFunction]=r.languages.SymbolKind.Function;var k=class extends y{static _convertOptions(e){return{ConvertTabsToSpaces:e.insertSpaces,TabSize:e.tabSize,IndentSize:e.tabSize,IndentStyle:2,NewLineCharacter:`
`,InsertSpaceAfterCommaDelimiter:!0,InsertSpaceAfterSemicolonInForStatements:!0,InsertSpaceBeforeAndAfterBinaryOperators:!0,InsertSpaceAfterKeywordsInControlFlowStatements:!0,InsertSpaceAfterFunctionKeywordForAnonymousFunctions:!0,InsertSpaceAfterOpeningAndBeforeClosingNonemptyParenthesis:!1,InsertSpaceAfterOpeningAndBeforeClosingNonemptyBrackets:!1,InsertSpaceAfterOpeningAndBeforeClosingTemplateStringBraces:!1,PlaceOpenBraceOnNewLineForControlBlocks:!1,PlaceOpenBraceOnNewLineForFunctions:!1}}_convertTextChanges(e,t){return{text:t.newText,range:this._textSpanToRange(e,t.span)}}},q=class extends k{async provideDocumentRangeFormattingEdits(e,t,i,s){let u=e.uri,p=e.getOffsetAt({lineNumber:t.startLineNumber,column:t.startColumn}),a=e.getOffsetAt({lineNumber:t.endLineNumber,column:t.endColumn}),o=await this._worker(u);if(e.isDisposed())return;let m=await o.getFormattingEditsForRange(u.toString(),p,a,k._convertOptions(i));if(!(!m||e.isDisposed()))return m.map(d=>this._convertTextChanges(e,d))}},Q=class extends k{get autoFormatTriggerCharacters(){return[";","}",`
`]}async provideOnTypeFormattingEdits(e,t,i,s,u){let p=e.uri,a=e.getOffsetAt(t),o=await this._worker(p);if(e.isDisposed())return;let m=await o.getFormattingEditsAfterKeystroke(p.toString(),a,i,k._convertOptions(s));if(!(!m||e.isDisposed()))return m.map(d=>this._convertTextChanges(e,d))}},X=class extends k{async provideCodeActions(e,t,i,s){let u=e.uri,p=e.getOffsetAt({lineNumber:t.startLineNumber,column:t.startColumn}),a=e.getOffsetAt({lineNumber:t.endLineNumber,column:t.endColumn}),o=k._convertOptions(e.getOptions()),m=i.markers.filter(f=>f.code).map(f=>f.code).map(Number),d=await this._worker(u);if(e.isDisposed())return;let g=await d.getCodeFixesAtPosition(u.toString(),p,a,m,o);return!g||e.isDisposed()?{actions:[],dispose:()=>{}}:{actions:g.filter(f=>f.changes.filter(S=>S.isNewFile).length===0).map(f=>this._tsCodeFixActionToMonacoCodeAction(e,i,f)),dispose:()=>{}}}_tsCodeFixActionToMonacoCodeAction(e,t,i){let s=[];for(let p of i.changes)for(let a of p.textChanges)s.push({resource:e.uri,edit:{range:this._textSpanToRange(e,a.span),text:a.newText}});return{title:i.description,edit:{edits:s},diagnostics:t.markers,kind:"quickfix"}}},Y=class extends y{constructor(e,t){super(t);this._libFiles=e}async provideRenameEdits(e,t,i,s){let u=e.uri,p=u.toString(),a=e.getOffsetAt(t),o=await this._worker(u);if(e.isDisposed())return;let m=await o.getRenameInfo(p,a,{allowRenameOfImportPath:!1});if(m.canRename===!1)return{edits:[],rejectReason:m.localizedErrorMessage};if(m.fileToRename!==void 0)throw new Error("Renaming files is not supported.");let d=await o.findRenameLocations(p,a,!1,!1,!1);if(!d||e.isDisposed())return;let g=[];for(let b of d){let f=this._libFiles.getOrCreateModel(b.fileName);if(f)g.push({resource:f.uri,edit:{range:this._textSpanToRange(f,b.textSpan),text:i}});else throw new Error(`Unknown file ${b.fileName}.`)}return{edits:g}}},Z=class extends y{async provideInlayHints(e,t,i){let s=e.uri,u=s.toString(),p=e.getOffsetAt({lineNumber:t.startLineNumber,column:t.startColumn}),a=e.getOffsetAt({lineNumber:t.endLineNumber,column:t.endColumn}),o=await this._worker(s);return e.isDisposed()?[]:(await o.provideInlayHints(u,p,a)).map(d=>({...d,position:e.getPositionAt(d.position),kind:this._convertHintKind(d.kind)}))}_convertHintKind(e){switch(e){case"Parameter":return r.languages.InlayHintKind.Parameter;case"Type":return r.languages.InlayHintKind.Type;default:return r.languages.InlayHintKind.Other}}};var K,ee;function xe(n){ee=ae(n,"typescript")}function ve(n){K=ae(n,"javascript")}function ke(){return new Promise((n,e)=>{if(!K)return e("JavaScript not registered!");n(K)})}function Se(){return new Promise((n,e)=>{if(!ee)return e("TypeScript not registered!");n(ee)})}function ae(n,e){let t=new E(e,n),i=(...u)=>t.getLanguageServiceWorker(...u),s=new U(i);return r.languages.registerCompletionItemProvider(e,new v(i)),r.languages.registerSignatureHelpProvider(e,new I(i)),r.languages.registerHoverProvider(e,new B(i)),r.languages.registerDocumentHighlightProvider(e,new $(i)),r.languages.registerDefinitionProvider(e,new z(s,i)),r.languages.registerReferenceProvider(e,new G(s,i)),r.languages.registerDocumentSymbolProvider(e,new J(i)),r.languages.registerDocumentRangeFormattingEditProvider(e,new q(i)),r.languages.registerOnTypeFormattingEditProvider(e,new Q(i)),r.languages.registerCodeActionProvider(e,new X(i)),r.languages.registerRenameProvider(e,new Y(s,i)),r.languages.registerInlayHintsProvider(e,new Z(i)),new j(s,n,e,i),i}return _e;})();
return moduleExports;
});
