/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareFetchRequestData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ShareFetchResponse;
import org.apache.kafka.common.requests.ShareRequestMetadata;

public class ShareFetchRequest
extends AbstractRequest {
    private final ShareFetchRequestData data;
    private volatile LinkedHashMap<TopicIdPartition, SharePartitionData> shareFetchData = null;
    private volatile List<TopicIdPartition> toForget = null;

    public ShareFetchRequest(ShareFetchRequestData data, short version) {
        super(ApiKeys.SHARE_FETCH, version);
        this.data = data;
    }

    @Override
    public ShareFetchRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        return new ShareFetchResponse(new ShareFetchResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()));
    }

    public static ShareFetchRequest parse(ByteBuffer buffer, short version) {
        return new ShareFetchRequest(new ShareFetchRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public int minBytes() {
        return this.data.minBytes();
    }

    public int maxBytes() {
        return this.data.maxBytes();
    }

    public int maxWait() {
        return this.data.maxWaitMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TopicIdPartition, SharePartitionData> shareFetchData(Map<Uuid, String> topicNames) {
        if (this.shareFetchData == null) {
            ShareFetchRequest shareFetchRequest = this;
            synchronized (shareFetchRequest) {
                if (this.shareFetchData == null) {
                    LinkedHashMap shareFetchDataTmp = new LinkedHashMap();
                    this.data.topics().forEach(shareFetchTopic -> {
                        String name = (String)topicNames.get(shareFetchTopic.topicId());
                        shareFetchTopic.partitions().forEach(shareFetchPartition -> shareFetchDataTmp.put(new TopicIdPartition(shareFetchTopic.topicId(), new TopicPartition(name, shareFetchPartition.partitionIndex())), new SharePartitionData(shareFetchTopic.topicId(), shareFetchPartition.partitionMaxBytes())));
                    });
                    this.shareFetchData = shareFetchDataTmp;
                }
            }
        }
        return this.shareFetchData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopicIdPartition> forgottenTopics(Map<Uuid, String> topicNames) {
        if (this.toForget == null) {
            ShareFetchRequest shareFetchRequest = this;
            synchronized (shareFetchRequest) {
                if (this.toForget == null) {
                    ArrayList<TopicIdPartition> toForgetTmp = new ArrayList<TopicIdPartition>();
                    this.data.forgottenTopicsData().forEach(forgottenTopic -> {
                        String name = (String)topicNames.get(forgottenTopic.topicId());
                        forgottenTopic.partitions().forEach(partitionId -> toForgetTmp.add(new TopicIdPartition(forgottenTopic.topicId(), new TopicPartition(name, (int)partitionId))));
                    });
                    this.toForget = toForgetTmp;
                }
            }
        }
        return this.toForget;
    }

    public static final class SharePartitionData {
        public final Uuid topicId;
        public final int maxBytes;

        public SharePartitionData(Uuid topicId, int maxBytes) {
            this.topicId = topicId;
            this.maxBytes = maxBytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SharePartitionData that = (SharePartitionData)o;
            return Objects.equals(this.topicId, that.topicId) && this.maxBytes == that.maxBytes;
        }

        public int hashCode() {
            return Objects.hash(this.topicId, this.maxBytes);
        }

        public String toString() {
            return "SharePartitionData(topicId=" + String.valueOf(this.topicId) + ", maxBytes=" + this.maxBytes + ")";
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<ShareFetchRequest> {
        private final ShareFetchRequestData data;

        public Builder(ShareFetchRequestData data) {
            this(data, false);
        }

        public Builder(ShareFetchRequestData data, boolean enableUnstableLastVersion) {
            super(ApiKeys.SHARE_FETCH, enableUnstableLastVersion);
            this.data = data;
        }

        public static Builder forConsumer(String groupId, ShareRequestMetadata metadata, int maxWait, int minBytes, int maxBytes, int fetchSize, List<TopicIdPartition> send, List<TopicIdPartition> forget, Map<TopicIdPartition, List<ShareFetchRequestData.AcknowledgementBatch>> acknowledgementsMap) {
            ShareFetchRequestData data = new ShareFetchRequestData();
            data.setGroupId(groupId);
            int ackOnlyPartitionMaxBytes = fetchSize;
            boolean isClosingShareSession = false;
            if (metadata != null) {
                data.setMemberId(metadata.memberId().toString());
                data.setShareSessionEpoch(metadata.epoch());
                if (metadata.isFinalEpoch()) {
                    isClosingShareSession = true;
                    ackOnlyPartitionMaxBytes = 0;
                }
            }
            data.setMaxWaitMs(maxWait);
            data.setMinBytes(minBytes);
            data.setMaxBytes(maxBytes);
            HashMap<Uuid, Map> fetchMap = new HashMap<Uuid, Map>();
            if (!isClosingShareSession) {
                for (TopicIdPartition topicIdPartition : send) {
                    Map partMap2 = fetchMap.computeIfAbsent(topicIdPartition.topicId(), k -> new HashMap());
                    ShareFetchRequestData.FetchPartition fetchPartition = new ShareFetchRequestData.FetchPartition().setPartitionIndex(topicIdPartition.partition()).setPartitionMaxBytes(fetchSize);
                    partMap2.put(topicIdPartition.partition(), fetchPartition);
                }
            }
            for (Map.Entry entry : acknowledgementsMap.entrySet()) {
                TopicIdPartition tip = (TopicIdPartition)entry.getKey();
                Map partMap3 = fetchMap.computeIfAbsent(tip.topicId(), k -> new HashMap());
                ShareFetchRequestData.FetchPartition fetchPartition = (ShareFetchRequestData.FetchPartition)partMap3.get(tip.partition());
                if (fetchPartition == null) {
                    fetchPartition = new ShareFetchRequestData.FetchPartition().setPartitionIndex(tip.partition()).setPartitionMaxBytes(ackOnlyPartitionMaxBytes);
                    partMap3.put(tip.partition(), fetchPartition);
                }
                fetchPartition.setAcknowledgementBatches((List)entry.getValue());
            }
            if (!fetchMap.isEmpty()) {
                data.setTopics(new ArrayList<ShareFetchRequestData.FetchTopic>());
                fetchMap.forEach((topicId, partMap) -> {
                    ShareFetchRequestData.FetchTopic fetchTopic = new ShareFetchRequestData.FetchTopic().setTopicId((Uuid)topicId).setPartitions(new ArrayList<ShareFetchRequestData.FetchPartition>());
                    partMap.forEach((index, fetchPartition) -> fetchTopic.partitions().add((ShareFetchRequestData.FetchPartition)fetchPartition));
                    data.topics().add(fetchTopic);
                });
            }
            Builder builder = new Builder(data, true);
            if (!forget.isEmpty()) {
                data.setForgottenTopicsData(new ArrayList<ShareFetchRequestData.ForgottenTopic>());
                builder.updateForgottenData(forget);
            }
            return builder;
        }

        public void updateForgottenData(List<TopicIdPartition> forget) {
            HashMap<Uuid, List> forgetMap = new HashMap<Uuid, List>();
            for (TopicIdPartition tip : forget) {
                List partList2 = forgetMap.computeIfAbsent(tip.topicId(), k -> new ArrayList());
                partList2.add(tip.partition());
            }
            forgetMap.forEach((topicId, partList) -> {
                ShareFetchRequestData.ForgottenTopic forgetTopic = new ShareFetchRequestData.ForgottenTopic().setTopicId((Uuid)topicId).setPartitions(new ArrayList<Integer>());
                partList.forEach(index -> forgetTopic.partitions().add((Integer)index));
                this.data.forgottenTopicsData().add(forgetTopic);
            });
        }

        public ShareFetchRequestData data() {
            return this.data;
        }

        @Override
        public ShareFetchRequest build(short version) {
            return new ShareFetchRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

