/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.lang3.Validate;

public class PidFile {
    private final File pidFile;

    public PidFile(File file) {
        Validate.notNull((Object)file, (String)("Invalid file '" + file + "' specified"), (Object[])new Object[0]);
        Validate.isTrue((boolean)file.exists(), (String)("Nonexistent file '" + file + "' specified"), (Object[])new Object[0]);
        this.pidFile = file;
    }

    public PidFile(File directory, String filename) throws FileNotFoundException {
        Validate.notNull((Object)directory, (String)("Invalid directory '" + directory + "' specified"), (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)filename, (String)("Invalid filename '" + filename + "' specified"), (Object[])new Object[0]);
        Validate.isTrue((directory.isDirectory() && directory.exists() ? 1 : 0) != 0, (String)("Nonexistent directory '" + directory + "' specified"), (Object[])new Object[0]);
        File file = new File(directory, filename);
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException("Unable to find PID file '" + filename + "' in directory '" + directory + "'");
        }
        this.pidFile = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readPid() throws IOException {
        String pidValue = null;
        try (BufferedReader fileReader = new BufferedReader(new FileReader(this.pidFile));){
            pidValue = fileReader.readLine();
            int pid = Integer.parseInt(pidValue);
            if (pid < 1) {
                throw new IllegalArgumentException("Invalid pid '" + pid + "' found in " + this.pidFile.getCanonicalPath());
            }
            int n = pid;
            return n;
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException("Invalid pid '" + pidValue + "' found in " + this.pidFile.getCanonicalPath());
        }
    }

    File getFile() {
        return this.pidFile;
    }
}

