/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.util.ManagementUtils;

public class CliUtils {
    public static String cliDependenciesExist(boolean includeGfshDependencies) {
        List unloadableJars;
        HashMap<String, String> classLibraryMap = new HashMap<String, String>();
        classLibraryMap.put("org.springframework.shell.core.Parser", "Spring Shell");
        classLibraryMap.put("org.springframework.shell.core.annotation.CliCommand", "Spring Shell");
        classLibraryMap.put("org.springframework.core.SpringVersion", "Spring Core");
        if (includeGfshDependencies) {
            classLibraryMap.put("jline.console.ConsoleReader", "JLine");
        }
        return (unloadableJars = classLibraryMap.entrySet().stream().filter(entry -> !CliUtils.canLoadClass((String)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList())).isEmpty() ? null : String.join((CharSequence)",", unloadableJars);
    }

    private static boolean canLoadClass(String className) {
        try {
            ClassPathLoader.getLatest().forName(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static String getMemberNameOrId(DistributedMember distributedMember) {
        String nameOrId = null;
        if (distributedMember != null) {
            nameOrId = distributedMember.getName();
            nameOrId = nameOrId != null && !nameOrId.isEmpty() ? nameOrId : distributedMember.getId();
        }
        return nameOrId;
    }

    public static Set<DistributedMember> getMembersWithAsyncEventQueue(InternalCache cache, String queueId) {
        Set members = ManagementUtils.findMembers(null, null, (InternalCache)cache);
        return members.stream().filter(m -> CliUtils.getAsyncEventQueueIds(cache, m).contains(queueId)).collect(Collectors.toSet());
    }

    public static Set<String> getAsyncEventQueueIds(InternalCache cache, DistributedMember member) {
        SystemManagementService managementService = (SystemManagementService)ManagementService.getExistingManagementService((Cache)cache);
        return managementService.getAsyncEventQueueMBeanNames(member).stream().map(x -> x.getKeyProperty("queue")).collect(Collectors.toSet());
    }

    public static DeflaterInflaterData compressBytes(byte[] input) {
        int compressedDataLength;
        Deflater compresser = new Deflater();
        compresser.setInput(input);
        compresser.finish();
        byte[] buffer = new byte[100];
        byte[] result = new byte[]{};
        int totalCompressedDataLength = 0;
        do {
            byte[] newResult = new byte[result.length + buffer.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            compressedDataLength = compresser.deflate(buffer);
            totalCompressedDataLength += compressedDataLength;
            System.arraycopy(buffer, 0, newResult, result.length, buffer.length);
            result = newResult;
        } while (compressedDataLength != 0);
        return new DeflaterInflaterData(totalCompressedDataLength, result);
    }

    public static DeflaterInflaterData uncompressBytes(byte[] output, int compressedDataLength) throws DataFormatException {
        Inflater decompresser = new Inflater();
        decompresser.setInput(output, 0, compressedDataLength);
        byte[] buffer = new byte[512];
        byte[] result = new byte[]{};
        while (!decompresser.needsInput()) {
            int bytesRead = decompresser.inflate(buffer);
            byte[] newResult = new byte[result.length + bytesRead];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(buffer, 0, newResult, result.length, bytesRead);
            result = newResult;
        }
        decompresser.end();
        return new DeflaterInflaterData(result.length, result);
    }

    public static String decodeWithDefaultCharSet(String urlToDecode) {
        try {
            return URLDecoder.decode(urlToDecode, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            return urlToDecode;
        }
    }

    @Deprecated
    public static <K> K newInstance(Class<K> klass, String neededFor) {
        K instance;
        try {
            instance = klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CliStrings.format((String)"Could not instantiate class \"{0}\" specified for \"{1}\".", (Object[])new Object[]{klass, neededFor}), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CliStrings.format((String)"Could not access class \"{0}\" specified for \"{1}\".", (Object[])new Object[]{klass, neededFor}), e);
        }
        return instance;
    }

    public static String resolvePathname(String pathname) {
        return StringUtils.isBlank((CharSequence)pathname) ? pathname : IOUtils.tryGetCanonicalPathElseGetAbsolutePath((File)new File(pathname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runLessCommandAsExternalViewer(Result commandResult) {
        StringBuilder sb = new StringBuilder();
        String NEW_LINE = System.lineSeparator();
        while (commandResult.hasNextLine()) {
            sb.append(commandResult.nextLine()).append(NEW_LINE);
        }
        commandResult.resetToFirstLine();
        File file = null;
        try {
            file = File.createTempFile("gfsh_output", "less");
            FileWriter fw = new FileWriter(file);
            fw.append(sb.toString());
            fw.close();
            File workingDir = file.getParentFile();
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "LESSOPEN=\"|color %s\" less -SR " + file.getName() + " < /dev/tty > /dev/tty "}, null, workingDir);
            p.waitFor();
        }
        catch (IOException | InterruptedException e) {
            Gfsh.println(e.getMessage());
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public static class DeflaterInflaterData
    implements Serializable {
        private static final long serialVersionUID = 1104813333595216795L;
        private final int dataLength;
        private final byte[] data;

        public DeflaterInflaterData(int dataLength, byte[] data) {
            this.dataLength = dataLength;
            this.data = data;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return String.valueOf(this.dataLength);
        }
    }
}

