/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;

public class AutoCreatedLeafQueueConfig {
    private QueueCapacities queueCapacities;
    private CapacitySchedulerConfiguration leafQueueConfigs;

    public AutoCreatedLeafQueueConfig(Builder builder) {
        this.queueCapacities = builder.queueCapacities;
        this.leafQueueConfigs = builder.leafQueueConfigs;
    }

    public QueueCapacities getQueueCapacities() {
        return this.queueCapacities;
    }

    public CapacitySchedulerConfiguration getLeafQueueConfigs() {
        return this.leafQueueConfigs;
    }

    public static class Builder {
        private QueueCapacities queueCapacities;
        private CapacitySchedulerConfiguration leafQueueConfigs;

        public Builder capacities(QueueCapacities capacities) {
            this.queueCapacities = capacities;
            return this;
        }

        public Builder configuration(CapacitySchedulerConfiguration conf) {
            this.leafQueueConfigs = conf;
            return this;
        }

        public AutoCreatedLeafQueueConfig build() {
            return new AutoCreatedLeafQueueConfig(this);
        }
    }
}

