/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.common;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerAllocationProposal;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.SchedulerContainer;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ResourceCommitRequest<A extends SchedulerApplicationAttempt, N extends SchedulerNode> {
    private List<ContainerAllocationProposal<A, N>> containersToAllocate = Collections.emptyList();
    private List<ContainerAllocationProposal<A, N>> containersToReserve = Collections.emptyList();
    private List<SchedulerContainer<A, N>> toReleaseContainers = Collections.emptyList();
    private Resource totalAllocatedResource;
    private Resource totalReservedResource;
    private Resource totalReleasedResource;

    public ResourceCommitRequest(List<ContainerAllocationProposal<A, N>> containersToAllocate, List<ContainerAllocationProposal<A, N>> containersToReserve, List<SchedulerContainer<A, N>> toReleaseContainers) {
        if (null != containersToAllocate) {
            this.containersToAllocate = containersToAllocate;
        }
        if (null != containersToReserve) {
            this.containersToReserve = containersToReserve;
        }
        if (null != toReleaseContainers) {
            this.toReleaseContainers = toReleaseContainers;
        }
        this.totalAllocatedResource = Resources.createResource((int)0);
        this.totalReservedResource = Resources.createResource((int)0);
        this.totalReleasedResource = Resources.createResource((int)0);
        for (ContainerAllocationProposal<A, N> containerAllocationProposal : this.containersToAllocate) {
            Resources.addTo((Resource)this.totalAllocatedResource, (Resource)containerAllocationProposal.getAllocatedOrReservedResource());
            for (SchedulerContainer<A, N> r : containerAllocationProposal.getToRelease()) {
                Resources.addTo((Resource)this.totalReleasedResource, (Resource)r.getRmContainer().getAllocatedOrReservedResource());
            }
        }
        for (ContainerAllocationProposal<A, N> containerAllocationProposal : this.containersToReserve) {
            Resources.addTo((Resource)this.totalReservedResource, (Resource)containerAllocationProposal.getAllocatedOrReservedResource());
            for (SchedulerContainer<A, N> r : containerAllocationProposal.getToRelease()) {
                Resources.addTo((Resource)this.totalReleasedResource, (Resource)r.getRmContainer().getAllocatedOrReservedResource());
            }
        }
        for (SchedulerContainer schedulerContainer : this.toReleaseContainers) {
            Resources.addTo((Resource)this.totalReleasedResource, (Resource)schedulerContainer.getRmContainer().getAllocatedOrReservedResource());
        }
    }

    public List<ContainerAllocationProposal<A, N>> getContainersToAllocate() {
        return this.containersToAllocate;
    }

    public List<ContainerAllocationProposal<A, N>> getContainersToReserve() {
        return this.containersToReserve;
    }

    public List<SchedulerContainer<A, N>> getContainersToRelease() {
        return this.toReleaseContainers;
    }

    public Resource getTotalAllocatedResource() {
        return this.totalAllocatedResource;
    }

    public Resource getTotalReservedResource() {
        return this.totalReservedResource;
    }

    public Resource getTotalReleasedResource() {
        return this.totalReleasedResource;
    }

    public boolean anythingAllocatedOrReserved() {
        return !this.containersToAllocate.isEmpty() || !this.containersToReserve.isEmpty();
    }

    public ContainerAllocationProposal<A, N> getFirstAllocatedOrReservedContainer() {
        ContainerAllocationProposal<A, N> c = null;
        if (!this.containersToAllocate.isEmpty()) {
            c = this.containersToAllocate.get(0);
        }
        if (c == null && !this.containersToReserve.isEmpty()) {
            c = this.containersToReserve.get(0);
        }
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("New " + this.getClass().getName() + ":\n");
        if (null != this.containersToAllocate && !this.containersToAllocate.isEmpty()) {
            sb.append("\t ALLOCATED=" + this.containersToAllocate.toString());
        }
        if (null != this.containersToReserve && !this.containersToReserve.isEmpty()) {
            sb.append("\t RESERVED=" + this.containersToReserve.toString());
        }
        if (null != this.toReleaseContainers && !this.toReleaseContainers.isEmpty()) {
            sb.append("\t RELEASED=" + this.toReleaseContainers.toString());
        }
        return sb.toString();
    }
}

