/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.info;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.annotation.DeveloperApi;

@DeveloperApi
public final class CatalogInfo {
    private final String name;
    private final Catalog.Type type;
    private final String provider;
    @Nullable
    private final String comment;
    private final Map<String, String> properties;
    @Nullable
    private final Audit auditInfo;

    public CatalogInfo(Catalog catalog) {
        this(catalog.name(), catalog.type(), catalog.provider(), catalog.comment(), catalog.properties(), catalog.auditInfo());
    }

    public CatalogInfo(String name, Catalog.Type type, String provider, String comment, Map<String, String> properties, Audit auditInfo) {
        this.name = name;
        this.type = type;
        this.provider = provider;
        this.comment = comment;
        this.properties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
        this.auditInfo = auditInfo;
    }

    public String name() {
        return this.name;
    }

    public Catalog.Type type() {
        return this.type;
    }

    public String provider() {
        return this.provider;
    }

    @Nullable
    public String comment() {
        return this.comment;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    @Nullable
    public Audit auditInfo() {
        return this.auditInfo;
    }
}

