/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Map;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.Providers;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.CatalogAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class CreateCatalog
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String provider;
    protected final String comment;
    protected final Map<String, String> properties;

    public CreateCatalog(CommandContext context, String metalake, String catalog, String provider, String comment, Map<String, String> properties) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.provider = provider;
        this.comment = comment;
        this.properties = properties;
    }

    @Override
    public void handle() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            client.createCatalog(this.catalog, Providers.catalogType(this.provider), Providers.internal(this.provider), this.comment, this.properties);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (CatalogAlreadyExistsException err) {
            this.exitWithError("Catalog already exists.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.catalog + " catalog created");
    }

    @Override
    public Command validate() {
        if (this.provider == null) {
            this.exitWithError("Missing --provider option.");
        }
        return super.validate();
    }
}

