/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.cli.AreYouSure;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchUserException;

public class DeleteUser
extends Command {
    protected final String metalake;
    protected final String user;
    protected final boolean force;

    public DeleteUser(CommandContext context, String metalake, String user) {
        super(context);
        this.force = context.force();
        this.metalake = metalake;
        this.user = user;
    }

    @Override
    public void handle() {
        boolean deleted = false;
        if ("anonymous".equalsIgnoreCase(this.user)) {
            this.exitWithError("Can't delete anonymous user. This will cause unexpected behavior.");
        }
        if (!AreYouSure.really(this.force)) {
            return;
        }
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            deleted = client.removeUser(this.user);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchUserException err) {
            this.exitWithError("Unknown user.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (deleted) {
            this.printInformation(this.user + " deleted.");
        } else {
            this.printInformation(this.user + " not deleted.");
        }
    }
}

