/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.CatalogChange;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class RemoveCatalogProperty
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String property;

    public RemoveCatalogProperty(CommandContext context, String metalake, String catalog, String property) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.property = property;
    }

    @Override
    public void handle() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            CatalogChange change = CatalogChange.removeProperty(this.property);
            client.alterCatalog(this.catalog, change);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.property + " property removed.");
    }

    @Override
    public Command validate() {
        this.validateProperty(this.property);
        return super.validate();
    }
}

