/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.TableCommand;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Strategy;

public class TableDistribution
extends TableCommand {
    protected final String schema;
    protected final String table;

    public TableDistribution(CommandContext context, String metalake, String catalog, String schema, String table) {
        super(context, metalake, catalog);
        this.schema = schema;
        this.table = table;
    }

    @Override
    public void handle() {
        Distribution distribution = null;
        try {
            NameIdentifier name = NameIdentifier.of(this.schema, this.table);
            distribution = this.tableCatalog().loadTable(name).distribution();
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (distribution.strategy() == Strategy.NONE) {
            this.printInformation(distribution.strategy().toString());
        } else {
            this.printInformation(String.valueOf((Object)distribution.strategy()) + "," + distribution.number());
        }
    }
}

