/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.model.Model;

public class ModelDTO
implements Model {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="properties")
    private Map<String, String> properties;
    @JsonProperty(value="latestVersion")
    private int latestVersion;
    @JsonProperty(value="audit")
    private AuditDTO audit;

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public int latestVersion() {
        return this.latestVersion;
    }

    @Override
    public AuditDTO auditInfo() {
        return this.audit;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ModelDTO() {
    }

    private ModelDTO(String name, String comment, Map<String, String> properties, int latestVersion, AuditDTO audit) {
        this.name = name;
        this.comment = comment;
        this.properties = properties;
        this.latestVersion = latestVersion;
        this.audit = audit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelDTO)) {
            return false;
        }
        ModelDTO other = (ModelDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.latestVersion != other.latestVersion) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.comment;
        String other$comment = other.comment;
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Map<String, String> this$properties = this.properties;
        Map<String, String> other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        AuditDTO this$audit = this.audit;
        AuditDTO other$audit = other.audit;
        return !(this$audit == null ? other$audit != null : !((Object)this$audit).equals(other$audit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.latestVersion;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.comment;
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Map<String, String> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        AuditDTO $audit = this.audit;
        result = result * 59 + ($audit == null ? 43 : ((Object)$audit).hashCode());
        return result;
    }

    public static class Builder {
        private String name;
        private String comment;
        private Map<String, String> properties;
        private int latestVersion;
        private AuditDTO audit;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder withLatestVersion(int latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public Builder withAudit(AuditDTO audit) {
            this.audit = audit;
            return this;
        }

        public ModelDTO build() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "name cannot be null or empty");
            Preconditions.checkArgument(this.latestVersion >= 0, "latestVersion cannot be negative");
            Preconditions.checkArgument(this.audit != null, "audit cannot be null");
            return new ModelDTO(this.name, this.comment, this.properties, this.latestVersion, this.audit);
        }
    }
}

