/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DelayingRunner
implements Runnable {
    private static final Log LOG = LogFactory.getLog(DelayingRunner.class);
    private final Object sleepLock = new Object();
    private boolean triggerWake = false;
    private long sleepTime;
    private MultiAction actions = new MultiAction();
    private Runnable runnable;

    public DelayingRunner(long sleepTime, Map.Entry<byte[], List<Action>> e) {
        this.sleepTime = sleepTime;
        this.add(e);
    }

    public void setRunner(Runnable runner) {
        this.runnable = runner;
    }

    @Override
    public void run() {
        if (!this.sleep()) {
            LOG.warn((Object)("Interrupted while sleeping for expected sleep time " + this.sleepTime + " ms"));
        }
        this.runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sleep() {
        long woke;
        long now;
        long startTime = now = EnvironmentEdgeManager.currentTime();
        for (long waitTime = this.sleepTime; waitTime > 0L; waitTime -= woke - startTime) {
            woke = -1L;
            try {
                Object object = this.sleepLock;
                synchronized (object) {
                    if (this.triggerWake) {
                        break;
                    }
                    this.sleepLock.wait(waitTime);
                }
                woke = EnvironmentEdgeManager.currentTime();
            }
            catch (InterruptedException iex) {
                return false;
            }
            woke = woke == -1L ? EnvironmentEdgeManager.currentTime() : woke;
        }
        return true;
    }

    public void add(Map.Entry<byte[], List<Action>> e) {
        this.actions.add(e.getKey(), e.getValue());
    }

    public MultiAction getActions() {
        return this.actions;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }
}

