/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.hudi.ops;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.catalog.lakehouse.hudi.HudiSchema;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;

public interface HudiCatalogBackendOps
extends AutoCloseable {
    public void initialize(Map<String, String> var1);

    public HudiSchema loadSchema(NameIdentifier var1) throws NoSuchSchemaException;

    public NameIdentifier[] listSchemas(Namespace var1) throws NoSuchCatalogException;

    default public boolean schemaExists(NameIdentifier ident) {
        try {
            this.loadSchema(ident);
            return true;
        }
        catch (NoSuchSchemaException e) {
            return false;
        }
    }

    public HudiSchema createSchema(NameIdentifier var1, String var2, Map<String, String> var3) throws NoSuchCatalogException, SchemaAlreadyExistsException;

    public HudiSchema alterSchema(NameIdentifier var1, SchemaChange ... var2) throws NoSuchSchemaException;

    public boolean dropSchema(NameIdentifier var1, boolean var2) throws NonEmptySchemaException;

    public NameIdentifier[] listTables(Namespace var1) throws NoSuchSchemaException;

    public Table loadTable(NameIdentifier var1) throws NoSuchTableException;

    default public boolean tableExists(NameIdentifier ident) {
        try {
            return this.loadTable(ident) != null;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    public Table createTable(NameIdentifier var1, Column[] var2, String var3, Map<String, String> var4, Transform[] var5, Distribution var6, SortOrder[] var7, Index[] var8) throws NoSuchSchemaException, TableAlreadyExistsException;

    public Table alterTable(NameIdentifier var1, TableChange ... var2) throws NoSuchTableException, IllegalArgumentException;

    public boolean dropTable(NameIdentifier var1);

    default public boolean purgeTable(NameIdentifier ident) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("purgeTable not supported.");
    }
}

