/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.utils;

import java.util.List;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;

public class YarnServerBuilderUtils {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public static NodeHeartbeatResponse newNodeHeartbeatResponse(NodeAction action, String diagnosticsMessage) {
        NodeHeartbeatResponse response = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
        response.setNodeAction(action);
        response.setDiagnosticsMessage(diagnosticsMessage);
        return response;
    }

    public static NodeHeartbeatResponse newNodeHeartbeatResponse(int responseId, NodeAction action, List<ContainerId> containersToCleanUp, List<ApplicationId> applicationsToCleanUp, MasterKey containerTokenMasterKey, MasterKey nmTokenMasterKey, long nextHeartbeatInterval) {
        NodeHeartbeatResponse response = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
        response.setResponseId(responseId);
        response.setNodeAction(action);
        response.setContainerTokenMasterKey(containerTokenMasterKey);
        response.setNMTokenMasterKey(nmTokenMasterKey);
        response.setNextHeartBeatInterval(nextHeartbeatInterval);
        if (containersToCleanUp != null) {
            response.addAllContainersToCleanup(containersToCleanUp);
        }
        if (applicationsToCleanUp != null) {
            response.addAllApplicationsToCleanup(applicationsToCleanUp);
        }
        return response;
    }
}

