/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.UserRoleRelBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.UserRoleRelPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.UserRoleRelPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class UserRoleRelSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, UserRoleRelBaseSQLProvider> USER_ROLE_RELATIONAL_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new UserRoleRelMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new UserRoleRelH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new UserRoleRelPostgreSQLProvider());

    public static UserRoleRelBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return USER_ROLE_RELATIONAL_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String batchInsertUserRoleRel(@Param(value="userRoleRels") List<UserRoleRelPO> userRoleRelPOs) {
        return UserRoleRelSQLProviderFactory.getProvider().batchInsertUserRoleRel(userRoleRelPOs);
    }

    public static String batchInsertUserRoleRelOnDuplicateKeyUpdate(@Param(value="userRoleRels") List<UserRoleRelPO> userRoleRelPOs) {
        return UserRoleRelSQLProviderFactory.getProvider().batchInsertUserRoleRelOnDuplicateKeyUpdate(userRoleRelPOs);
    }

    public static String softDeleteUserRoleRelByUserId(@Param(value="userId") Long userId) {
        return UserRoleRelSQLProviderFactory.getProvider().softDeleteUserRoleRelByUserId(userId);
    }

    public static String softDeleteUserRoleRelByUserAndRoles(@Param(value="userId") Long userId, @Param(value="roleIds") List<Long> roleIds) {
        return UserRoleRelSQLProviderFactory.getProvider().softDeleteUserRoleRelByUserAndRoles(userId, roleIds);
    }

    public static String softDeleteUserRoleRelByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return UserRoleRelSQLProviderFactory.getProvider().softDeleteUserRoleRelByMetalakeId(metalakeId);
    }

    public static String softDeleteUserRoleRelByRoleId(@Param(value="roleId") Long roleId) {
        return UserRoleRelSQLProviderFactory.getProvider().softDeleteUserRoleRelByRoleId(roleId);
    }

    public static String deleteUserRoleRelMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return UserRoleRelSQLProviderFactory.getProvider().deleteUserRoleRelMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class UserRoleRelMySQLProvider
    extends UserRoleRelBaseSQLProvider {
        UserRoleRelMySQLProvider() {
        }
    }

    static class UserRoleRelH2Provider
    extends UserRoleRelBaseSQLProvider {
        UserRoleRelH2Provider() {
        }
    }
}

