/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc.converter;

import java.sql.SQLException;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;

public class JdbcExceptionConverter {
    public GravitinoRuntimeException toGravitinoException(SQLException sqlException) {
        switch (sqlException.getErrorCode()) {
            case 1007: {
                return new SchemaAlreadyExistsException((Throwable)sqlException, sqlException.getMessage(), new Object[0]);
            }
            case 1050: {
                return new TableAlreadyExistsException((Throwable)sqlException, sqlException.getMessage(), new Object[0]);
            }
            case 1008: 
            case 1049: {
                return new NoSuchSchemaException((Throwable)sqlException, sqlException.getMessage(), new Object[0]);
            }
            case 1051: 
            case 1146: {
                return new NoSuchTableException((Throwable)sqlException, sqlException.getMessage(), new Object[0]);
            }
        }
        if (sqlException.getMessage() != null && sqlException.getMessage().contains("Access denied")) {
            return new ConnectionFailedException((Throwable)sqlException, sqlException.getMessage(), new Object[0]);
        }
        return new GravitinoRuntimeException((Throwable)sqlException, sqlException.getMessage());
    }
}

