/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compression;

import org.apache.paimon.compression.AirBlockCompressor;
import org.apache.paimon.compression.AirBlockDecompressor;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.compression.BlockCompressionType;
import org.apache.paimon.compression.BlockCompressor;
import org.apache.paimon.compression.BlockDecompressor;
import org.apache.paimon.shade.io.airlift.compress.Compressor;
import org.apache.paimon.shade.io.airlift.compress.Decompressor;

public class AirCompressorFactory
implements BlockCompressionFactory {
    private final BlockCompressionType type;
    private final Compressor internalCompressor;
    private final Decompressor internalDecompressor;

    public AirCompressorFactory(BlockCompressionType type, Compressor internalCompressor, Decompressor internalDecompressor) {
        this.type = type;
        this.internalCompressor = internalCompressor;
        this.internalDecompressor = internalDecompressor;
    }

    @Override
    public BlockCompressionType getCompressionType() {
        return this.type;
    }

    @Override
    public BlockCompressor getCompressor() {
        return new AirBlockCompressor(this.internalCompressor);
    }

    @Override
    public BlockDecompressor getDecompressor() {
        return new AirBlockDecompressor(this.internalDecompressor);
    }
}

