/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar.heap;

import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarRow;
import org.apache.paimon.data.columnar.RowColumnVector;
import org.apache.paimon.data.columnar.VectorizedColumnBatch;
import org.apache.paimon.data.columnar.heap.HeapRowVector;

public class CastedRowColumnVector
implements RowColumnVector {
    private final VectorizedColumnBatch vectorizedColumnBatch;
    private final HeapRowVector heapRowVector;
    private final ColumnVector[] children;

    public CastedRowColumnVector(HeapRowVector heapRowVector, ColumnVector[] children) {
        this.heapRowVector = heapRowVector;
        this.children = children;
        this.vectorizedColumnBatch = new VectorizedColumnBatch(children);
    }

    @Override
    public InternalRow getRow(int i) {
        ColumnarRow columnarRow = new ColumnarRow(this.vectorizedColumnBatch);
        columnarRow.setRowId(i);
        return columnarRow;
    }

    @Override
    public VectorizedColumnBatch getBatch() {
        return this.vectorizedColumnBatch;
    }

    @Override
    public boolean isNullAt(int i) {
        return this.heapRowVector.isNullAt(i);
    }

    @Override
    public int getCapacity() {
        return this.heapRowVector.getCapacity();
    }

    @Override
    public ColumnVector[] getChildren() {
        return this.children;
    }
}

