/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive.client;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.gravitino.exceptions.AlreadyExistsException;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.PartitionAlreadyExistsException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;

public class HiveExceptionConverter {
    private static final Set<String> NO_SUCH_EXCEPTION_SET = Set.of("NoSuchObjectException", "UnknownTableException", "UnknownDBException", "UnknownPartitionException", "InvalidObjectException", "InvalidPartitionException");

    private HiveExceptionConverter() {
    }

    public static RuntimeException toGravitinoException(Exception e, ExceptionTarget target) {
        Throwable cause = HiveExceptionConverter.unwrapException(e);
        return HiveExceptionConverter.convertException(cause, target);
    }

    private static Throwable unwrapException(Exception e) {
        InvocationTargetException ite;
        Throwable cause = e;
        if (e instanceof InvocationTargetException && (cause = (ite = (InvocationTargetException)e).getTargetException()) == null) {
            cause = e;
        }
        return cause;
    }

    private static RuntimeException convertException(Throwable cause, ExceptionTarget target) {
        if (cause instanceof RuntimeException && cause.getCause() instanceof Exception) {
            return HiveExceptionConverter.toGravitinoException((Exception)cause.getCause(), target);
        }
        String message = cause.getMessage();
        String lowerMessage = message != null ? message.toLowerCase(Locale.ROOT) : "";
        String exceptionClassName = cause.getClass().getSimpleName();
        if (exceptionClassName.contains("AlreadyExistsException")) {
            return HiveExceptionConverter.toAlreadyExistsException(cause, target, message);
        }
        if (NO_SUCH_EXCEPTION_SET.contains(exceptionClassName)) {
            return HiveExceptionConverter.toNoSuchObjectException(cause, target, message);
        }
        if (exceptionClassName.contains("InvalidOperationException")) {
            if (HiveExceptionConverter.isNonEmptySchemaMessage(lowerMessage)) {
                return new NonEmptySchemaException(cause, "Hive schema %s is not empty in Hive Metastore", new Object[]{target.name()});
            }
            return new IllegalArgumentException(cause.getMessage(), cause);
        }
        if (exceptionClassName.contains("MetaException") && lowerMessage.contains("invalid partition key")) {
            return new NoSuchPartitionException(cause, "Hive partition %s does not exist in Hive Metastore", new Object[]{target.name()});
        }
        if (exceptionClassName.contains("TException")) {
            if (lowerMessage.contains("already exists")) {
                return HiveExceptionConverter.toAlreadyExistsException(cause, target, message);
            }
            if (HiveExceptionConverter.isNotFoundKeyword(lowerMessage)) {
                return HiveExceptionConverter.toNoSuchObjectException(cause, target, message);
            }
            if (HiveExceptionConverter.isNonEmptySchemaMessage(lowerMessage)) {
                return new NonEmptySchemaException(cause, "Hive schema %s is not empty in Hive Metastore", new Object[]{target.name()});
            }
        }
        if (HiveExceptionConverter.isConnectionKeyword(lowerMessage) || exceptionClassName.contains("TransportException")) {
            return new ConnectionFailedException(cause, "Failed to connect to Hive Metastore: %s", new Object[]{target.name()});
        }
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        return new GravitinoRuntimeException(cause, message);
    }

    private static boolean isNotFoundKeyword(String lowerMessage) {
        return Stream.of("does not exist", "not found", "no such", "there is no").anyMatch(lowerMessage::contains);
    }

    private static boolean isConnectionKeyword(String lowerMessage) {
        return Stream.of("connection", "connect", "timeout", "network").anyMatch(lowerMessage::contains);
    }

    private static boolean isNonEmptySchemaMessage(String lowerMessage) {
        return !(!lowerMessage.contains("non-empty") && !lowerMessage.contains("not empty") || !lowerMessage.contains("schema") && !lowerMessage.contains("database"));
    }

    private static RuntimeException toAlreadyExistsException(Throwable cause, ExceptionTarget target, String rawMessage) {
        TargetType objectType = target.type();
        return switch (objectType) {
            case TargetType.PARTITION -> new PartitionAlreadyExistsException(cause, "Hive partition %s already exists in Hive Metastore", new Object[]{target.name()});
            case TargetType.TABLE -> new TableAlreadyExistsException(cause, "Hive table %s already exists in Hive Metastore", new Object[]{target.name()});
            case TargetType.SCHEMA -> new SchemaAlreadyExistsException(cause, "Hive schema %s already exists in Hive Metastore", new Object[]{target.name()});
            default -> new AlreadyExistsException(cause, "%s", new Object[]{rawMessage});
        };
    }

    private static RuntimeException toNoSuchObjectException(Throwable cause, ExceptionTarget target, String rawMessage) {
        return switch (target.type()) {
            case TargetType.PARTITION -> new NoSuchPartitionException(cause, "Hive partition %s does not exist in Hive Metastore", new Object[]{target.name()});
            case TargetType.TABLE -> new NoSuchTableException(cause, "Hive table %s does not exist in Hive Metastore", new Object[]{target.name()});
            case TargetType.SCHEMA -> new NoSuchSchemaException(cause, "Hive schema %s does not exist in Hive Metastore", new Object[]{target.name()});
            default -> new NoSuchEntityException(cause, "%s", new Object[]{rawMessage});
        };
    }

    public static final class ExceptionTarget {
        private final String name;
        private final TargetType type;

        private ExceptionTarget(String name, TargetType type) {
            this.name = name;
            this.type = type;
        }

        public static ExceptionTarget table(String name) {
            return new ExceptionTarget(name, TargetType.TABLE);
        }

        public static ExceptionTarget schema(String name) {
            return new ExceptionTarget(name, TargetType.SCHEMA);
        }

        public static ExceptionTarget catalog(String name) {
            return new ExceptionTarget(name, TargetType.CATALOG);
        }

        public static ExceptionTarget partition(String name) {
            return new ExceptionTarget(name, TargetType.PARTITION);
        }

        public static ExceptionTarget other(String name) {
            return new ExceptionTarget(name, TargetType.OTHER);
        }

        public String name() {
            return this.name;
        }

        public TargetType type() {
            return this.type;
        }
    }

    private static enum TargetType {
        TABLE,
        SCHEMA,
        PARTITION,
        CATALOG,
        OTHER;

    }
}

