/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.compaction;

import com.lancedb.lance.Dataset;
import com.lancedb.lance.compaction.CompactionOptions;
import com.lancedb.lance.compaction.RewriteResult;
import com.lancedb.lance.compaction.TaskData;
import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.io.Serializable;
import java.util.Optional;

public class CompactionTask
implements Serializable {
    private final TaskData taskData;
    private final long readVersion;
    private final CompactionOptions compactionOptions;

    public CompactionTask(TaskData taskData, long readVersion, CompactionOptions compactionOptions) {
        this.taskData = taskData;
        this.readVersion = readVersion;
        this.compactionOptions = compactionOptions;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("taskData", this.taskData.getFragments()).add("readVersion", this.readVersion).add("compactionOptions", this.compactionOptions).toString();
    }

    public RewriteResult execute(Dataset dataset) {
        return this.nativeExecute(dataset, this.taskData, this.readVersion, this.compactionOptions.getTargetRowsPerFragment(), this.compactionOptions.getMaxRowsPerGroup(), this.compactionOptions.getMaxBytesPerFile(), this.compactionOptions.getMaterializeDeletions(), this.compactionOptions.getMaterializeDeletionsThreshold(), this.compactionOptions.getNumThreads(), this.compactionOptions.getBatchSize(), this.compactionOptions.getDeferIndexRemap());
    }

    private native RewriteResult nativeExecute(Dataset var1, TaskData var2, long var3, Optional<Long> var5, Optional<Long> var6, Optional<Long> var7, Optional<Boolean> var8, Optional<Float> var9, Optional<Long> var10, Optional<Long> var11, Optional<Boolean> var12);

    public CompactionOptions getCompactionOptions() {
        return this.compactionOptions;
    }

    public long getReadVersion() {
        return this.readVersion;
    }

    public TaskData getTaskData() {
        return this.taskData;
    }
}

