/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.operation;

import com.lancedb.lance.operation.Operation;
import com.lancedb.lance.operation.UpdateMap;
import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class UpdateConfig
implements Operation {
    private final UpdateMap configUpdates;
    private final UpdateMap tableMetadataUpdates;
    private final UpdateMap schemaMetadataUpdates;
    private final Map<Integer, UpdateMap> fieldMetadataUpdates;

    private UpdateConfig(UpdateMap configUpdates, UpdateMap tableMetadataUpdates, UpdateMap schemaMetadataUpdates, Map<Integer, UpdateMap> fieldMetadataUpdates) {
        this.configUpdates = configUpdates;
        this.tableMetadataUpdates = tableMetadataUpdates;
        this.schemaMetadataUpdates = schemaMetadataUpdates;
        this.fieldMetadataUpdates = fieldMetadataUpdates != null ? fieldMetadataUpdates : new HashMap();
    }

    @Deprecated
    private UpdateConfig(Map<String, String> upsertValues, List<String> deleteKeys, Map<String, String> schemaMetadata, Map<Integer, Map<String, String>> fieldMetadata) {
        if (upsertValues != null || deleteKeys != null) {
            HashMap<String, String> configMap = new HashMap<String, String>();
            if (upsertValues != null) {
                configMap.putAll(upsertValues);
            }
            if (deleteKeys != null) {
                for (String string : deleteKeys) {
                    configMap.put(string, null);
                }
            }
            this.configUpdates = configMap.isEmpty() ? null : UpdateMap.builder().updates(configMap).replace(false).build();
        } else {
            this.configUpdates = null;
        }
        this.tableMetadataUpdates = null;
        UpdateMap updateMap = this.schemaMetadataUpdates = schemaMetadata == null || schemaMetadata.isEmpty() ? null : UpdateMap.builder().updates(schemaMetadata).replace(false).build();
        if (fieldMetadata == null || fieldMetadata.isEmpty()) {
            this.fieldMetadataUpdates = new HashMap<Integer, UpdateMap>();
        } else {
            HashMap<Integer, UpdateMap> convertedFieldMetadata = new HashMap<Integer, UpdateMap>();
            for (Map.Entry entry : fieldMetadata.entrySet()) {
                if (entry.getValue() == null || ((Map)entry.getValue()).isEmpty()) continue;
                UpdateMap fieldUpdateMap = UpdateMap.builder().updates((Map)entry.getValue()).replace(false).build();
                convertedFieldMetadata.put((Integer)entry.getKey(), fieldUpdateMap);
            }
            this.fieldMetadataUpdates = convertedFieldMetadata;
        }
    }

    public UpdateMap configUpdates() {
        return this.configUpdates;
    }

    public UpdateMap tableMetadataUpdates() {
        return this.tableMetadataUpdates;
    }

    public UpdateMap schemaMetadataUpdates() {
        return this.schemaMetadataUpdates;
    }

    public Map<Integer, UpdateMap> fieldMetadataUpdates() {
        return this.fieldMetadataUpdates;
    }

    @Deprecated
    public Optional<Map<String, String>> upsertValues() {
        if (this.configUpdates == null) {
            return Optional.empty();
        }
        HashMap<String, String> upsertMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.configUpdates.updates().entrySet()) {
            if (entry.getValue() == null) continue;
            upsertMap.put(entry.getKey(), entry.getValue());
        }
        return upsertMap.isEmpty() ? Optional.empty() : Optional.of(upsertMap);
    }

    @Deprecated
    public Optional<List<String>> deleteKeys() {
        if (this.configUpdates == null) {
            return Optional.empty();
        }
        List deleteList = this.configUpdates.updates().entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toList());
        return deleteList.isEmpty() ? Optional.empty() : Optional.of(deleteList);
    }

    @Deprecated
    public Optional<Map<String, String>> schemaMetadata() {
        if (this.schemaMetadataUpdates == null) {
            return Optional.empty();
        }
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.schemaMetadataUpdates.updates().entrySet()) {
            if (entry.getValue() == null) continue;
            metadataMap.put(entry.getKey(), entry.getValue());
        }
        return metadataMap.isEmpty() ? Optional.empty() : Optional.of(metadataMap);
    }

    @Deprecated
    public Optional<Map<Integer, Map<String, String>>> fieldMetadata() {
        if (this.fieldMetadataUpdates == null || this.fieldMetadataUpdates.isEmpty()) {
            return Optional.empty();
        }
        HashMap legacyFieldMetadata = new HashMap();
        for (Map.Entry<Integer, UpdateMap> entry : this.fieldMetadataUpdates.entrySet()) {
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            for (Map.Entry<String, String> updateEntry : entry.getValue().updates().entrySet()) {
                if (updateEntry.getValue() == null) continue;
                fieldMap.put(updateEntry.getKey(), updateEntry.getValue());
            }
            if (fieldMap.isEmpty()) continue;
            legacyFieldMetadata.put(entry.getKey(), fieldMap);
        }
        return legacyFieldMetadata.isEmpty() ? Optional.empty() : Optional.of(legacyFieldMetadata);
    }

    @Override
    public String name() {
        return "UpdateConfig";
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("configUpdates", this.configUpdates).add("tableMetadataUpdates", this.tableMetadataUpdates).add("schemaMetadataUpdates", this.schemaMetadataUpdates).add("fieldMetadataUpdates", this.fieldMetadataUpdates).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private UpdateMap configUpdates;
        private UpdateMap tableMetadataUpdates;
        private UpdateMap schemaMetadataUpdates;
        private Map<Integer, UpdateMap> fieldMetadataUpdates;

        public Builder configUpdates(UpdateMap configUpdates) {
            this.configUpdates = configUpdates;
            return this;
        }

        public Builder tableMetadataUpdates(UpdateMap tableMetadataUpdates) {
            this.tableMetadataUpdates = tableMetadataUpdates;
            return this;
        }

        public Builder schemaMetadataUpdates(UpdateMap schemaMetadataUpdates) {
            this.schemaMetadataUpdates = schemaMetadataUpdates;
            return this;
        }

        public Builder fieldMetadataUpdates(Map<Integer, UpdateMap> fieldMetadataUpdates) {
            this.fieldMetadataUpdates = fieldMetadataUpdates;
            return this;
        }

        public UpdateConfig build() {
            return new UpdateConfig(this.configUpdates, this.tableMetadataUpdates, this.schemaMetadataUpdates, this.fieldMetadataUpdates);
        }

        @Deprecated
        public Builder upsertValues(Map<String, String> upsertValues) {
            if (upsertValues != null && !upsertValues.isEmpty()) {
                this.configUpdates = UpdateMap.builder().updates(upsertValues).replace(false).build();
            }
            return this;
        }

        @Deprecated
        public Builder deleteKeys(List<String> deleteKeys) {
            if (deleteKeys != null && !deleteKeys.isEmpty()) {
                HashMap<String, String> deleteMap = new HashMap<String, String>();
                for (String key : deleteKeys) {
                    deleteMap.put(key, null);
                }
                if (this.configUpdates != null) {
                    HashMap<String, String> combinedUpdates = new HashMap<String, String>(this.configUpdates.updates());
                    combinedUpdates.putAll(deleteMap);
                    this.configUpdates = UpdateMap.builder().updates(combinedUpdates).replace(this.configUpdates.replace()).build();
                } else {
                    this.configUpdates = UpdateMap.builder().updates(deleteMap).replace(false).build();
                }
            }
            return this;
        }

        @Deprecated
        public Builder schemaMetadata(Map<String, String> schemaMetadata) {
            if (schemaMetadata != null && !schemaMetadata.isEmpty()) {
                this.schemaMetadataUpdates = UpdateMap.builder().updates(schemaMetadata).replace(false).build();
            }
            return this;
        }

        @Deprecated
        public Builder fieldMetadata(Map<Integer, Map<String, String>> fieldMetadata) {
            if (fieldMetadata != null && !fieldMetadata.isEmpty()) {
                HashMap<Integer, UpdateMap> convertedFieldMetadata = new HashMap<Integer, UpdateMap>();
                for (Map.Entry<Integer, Map<String, String>> entry : fieldMetadata.entrySet()) {
                    if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                    UpdateMap fieldUpdateMap = UpdateMap.builder().updates(entry.getValue()).replace(false).build();
                    convertedFieldMetadata.put(entry.getKey(), fieldUpdateMap);
                }
                this.fieldMetadataUpdates = convertedFieldMetadata;
            }
            return this;
        }
    }
}

